/*
 * Decompiled with CFR 0.152.
 */
package org.ensime.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.util.AttributeKey;
import java.io.Serializable;
import org.ensime.api.EnsimeServerError;
import org.ensime.api.EnsimeServerMessage;
import org.ensime.api.RpcRequestEnvelope;
import org.ensime.api.RpcResponseEnvelope;
import org.ensime.server.JerkySubprotocolEncoder$;
import org.ensime.server.SubprotocolEncoder;
import org.ensime.server.SwankySubprotocolEncoder$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u0001%\u0011QcV3c'>\u001c7.\u001a;Ge\u0006lW\rS1oI2,'O\u0003\u0002\u0004\t\u000511/\u001a:wKJT!!\u0002\u0004\u0002\r\u0015t7/[7f\u0015\u00059\u0011aA8sO\u000e\u00011C\u0001\u0001\u000b!\rY!\u0003F\u0007\u0002\u0019)\u0011QBD\u0001\bG\"\fgN\\3m\u0015\ty\u0001#A\u0003oKR$\u0018PC\u0001\u0012\u0003\tIw.\u0003\u0002\u0014\u0019\tY2+[7qY\u0016\u001c\u0005.\u00198oK2LeNY8v]\u0012D\u0015M\u001c3mKJ\u0004\"!\u0006\u0010\u000e\u0003YQ!a\u0006\r\u0002\u0015],'m]8dW\u0016$\bP\u0003\u0002\u001a5\u0005!\u0001\u000e\u001e;q\u0015\tYB$A\u0003d_\u0012,7M\u0003\u0002\u001e\u001d\u00059\u0001.\u00198eY\u0016\u0014\u0018BA\u0010\u0017\u000599VMY*pG.,GO\u0012:b[\u0016D\u0001\"\t\u0001\u0003\u0002\u0003\u0006IAI\u0001\rQ>|7\u000eS1oI2,'o\u001d\t\u0003G=r!\u0001J\u0017\u000f\u0005\u0015bcB\u0001\u0014,\u001d\t9#&D\u0001)\u0015\tI\u0003\"\u0001\u0004=e>|GOP\u0005\u0002\u000f%\u0011QAB\u0005\u0003\u0007\u0011I!A\f\u0002\u0002\u0013]+'mU3sm\u0016\u0014\u0018B\u0001\u00192\u00051Aun\\6IC:$G.\u001a:t\u0015\tq#\u0001C\u00034\u0001\u0011\u0005A'\u0001\u0004=S:LGO\u0010\u000b\u0003k]\u0002\"A\u000e\u0001\u000e\u0003\tAQ!\t\u001aA\u0002\tBq!\u000f\u0001C\u0002\u0013\u0005!(A\u0002m_\u001e,\u0012a\u000f\t\u0003y}j\u0011!\u0010\u0006\u0003}\u0019\tQa\u001d7gi)L!\u0001Q\u001f\u0003\r1{wmZ3s\u0011\u0019\u0011\u0005\u0001)A\u0005w\u0005!An\\4!\u0011\u001d!\u0005A1A\u0005\u0002\u0015\u000bA\"\u001b8IC:$G.\u001a:LKf,\u0012A\u0012\t\u0004\u000f*cU\"\u0001%\u000b\u0005%s\u0011\u0001B;uS2L!a\u0013%\u0003\u0019\u0005#HO]5ckR,7*Z=\u0011\t5\u0003&KW\u0007\u0002\u001d*\tq*A\u0003tG\u0006d\u0017-\u0003\u0002R\u001d\nIa)\u001e8di&|g.\r\t\u0003'^s!\u0001V+\u0011\u0005\u001dr\u0015B\u0001,O\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001,\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Ys\u0005CA'\\\u0013\tafJ\u0001\u0003V]&$\bB\u00020\u0001A\u0003%a)A\u0007j]\"\u000bg\u000e\u001a7fe.+\u0017\u0010\t\u0005\bA\u0002\u0011\r\u0011\"\u0001b\u00035yW\u000f\u001e%b]\u0012dWM]&fsV\t!\rE\u0002H\u0015\u000e\u0004\"a\t3\n\u0005\u0015\f$aD(vi\u001e|\u0017N\\4IC:$G.\u001a:\t\r\u001d\u0004\u0001\u0015!\u0003c\u00039yW\u000f\u001e%b]\u0012dWM]&fs\u0002BQ!\u001b\u0001\u0005\n)\fAb]3u\u0013:D\u0015M\u001c3mKJ$2AW6q\u0011\u0015a\u0007\u000e1\u0001n\u0003\r\u0019G\u000f\u001f\t\u0003\u00179L!a\u001c\u0007\u0003+\rC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe\u000e{g\u000e^3yi\")\u0011\u000f\u001ba\u0001\u0019\u0006I\u0011N\u001c%b]\u0012dWM\u001d\u0005\u0006g\u0002!I\u0001^\u0001\rO\u0016$\u0018J\u001c%b]\u0012dWM\u001d\u000b\u0003\u0019VDQ\u0001\u001c:A\u00025DQa\u001e\u0001\u0005\na\fQb]3u\u001fV$\b*\u00198eY\u0016\u0014Hc\u0001.zu\")AN\u001ea\u0001[\")1P\u001ea\u0001G\u0006Qq.\u001e;IC:$G.\u001a:\t\u000bu\u0004A\u0011\u0002@\u0002\u001b\u001d,GoT;u\u0011\u0006tG\r\\3s)\t\u0019w\u0010C\u0003my\u0002\u0007Q\u000eC\u0004\u0002\u0004\u0001!I!!\u0002\u0002\u0015\u0015t7m\u001c3fe\u001a{'\u000f\u0006\u0003\u0002\b\u00055\u0001c\u0001\u001c\u0002\n%\u0019\u00111\u0002\u0002\u0003%M+(\r\u001d:pi>\u001cw\u000e\\#oG>$WM\u001d\u0005\b\u0003\u001f\t\t\u00011\u0001S\u0003-\u0019XO\u00199s_R|7m\u001c7\t\u000f\u0005M\u0001\u0001\"\u0003\u0002\u0016\u0005\tRM\\2pI\u0016$w*\u001e;IC:$G.\u001a:\u0015\u000b\r\f9\"!\t\t\u0011\u0005e\u0011\u0011\u0003a\u0001\u00037\t!a\u00195\u0011\u0007-\ti\"C\u0002\u0002 1\u0011qa\u00115b]:,G\u000e\u0003\u0005\u0002$\u0005E\u0001\u0019AA\u0004\u0003\u001d)gnY8eKJDq!a\n\u0001\t\u0013\tI#\u0001\tf]\u000e|G-\u001a3J]\"\u000bg\u000e\u001a7feR)A*a\u000b\u00024!9\u0011/!\nA\u0002\u00055\u0002cA\u0012\u00020%\u0019\u0011\u0011G\u0019\u0003\u001f%s7m\\7j]\u001eD\u0015M\u001c3mKJD\u0001\"a\t\u0002&\u0001\u0007\u0011q\u0001\u0005\b\u0003o\u0001A\u0011KA\u001d\u0003I)8/\u001a:Fm\u0016tG\u000f\u0016:jO\u001e,'/\u001a3\u0015\u000bi\u000bY$!\u0010\t\r1\f)\u00041\u0001n\u0011!\ty$!\u000eA\u0002\u0005\u0005\u0013aA3wiB!\u00111IA'\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013\u0001\u00027b]\u001eT!!a\u0013\u0002\t)\fg/Y\u0005\u0005\u0003\u001f\n)E\u0001\u0004PE*,7\r\u001e\u0005\b\u0003'\u0002A\u0011KA+\u00031\u0019\u0007.\u00198oK2\u0014V-\u001931)\u0015Q\u0016qKA-\u0011\u0019a\u0017\u0011\u000ba\u0001[\"9\u00111LA)\u0001\u0004!\u0012!\u00024sC6,\u0007bBA0\u0001\u0011E\u0013\u0011M\u0001\u0010Kb\u001cW\r\u001d;j_:\u001c\u0015-^4iiR)!,a\u0019\u0002f!1A.!\u0018A\u00025D\u0001\"a\u001a\u0002^\u0001\u0007\u0011\u0011N\u0001\u0002iB!\u00111NA;\u001d\u0011\ti'!\u001d\u000f\u0007\u001d\ny'C\u0001P\u0013\r\t\u0019HT\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9(!\u001f\u0003\u0013QC'o\\<bE2,'bAA:\u001d\u0002")
public class WebSocketFrameHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private final Function1<Function1<RpcResponseEnvelope, BoxedUnit>, Function1<RpcRequestEnvelope, BoxedUnit>> hookHandlers;
    private final Logger log;
    private final AttributeKey<Function1<String, BoxedUnit>> inHandlerKey;
    private final AttributeKey<Function1<RpcResponseEnvelope, BoxedUnit>> outHandlerKey;

    public Logger log() {
        return this.log;
    }

    public AttributeKey<Function1<String, BoxedUnit>> inHandlerKey() {
        return this.inHandlerKey;
    }

    public AttributeKey<Function1<RpcResponseEnvelope, BoxedUnit>> outHandlerKey() {
        return this.outHandlerKey;
    }

    private void setInHandler(ChannelHandlerContext ctx, Function1<String, BoxedUnit> inHandler) {
        ctx.channel().attr(this.inHandlerKey()).set(inHandler);
    }

    private Function1<String, BoxedUnit> getInHandler(ChannelHandlerContext ctx) {
        return (Function1)ctx.channel().attr(this.inHandlerKey()).get();
    }

    private void setOutHandler(ChannelHandlerContext ctx, Function1<RpcResponseEnvelope, BoxedUnit> outHandler) {
        ctx.channel().attr(this.outHandlerKey()).set(outHandler);
    }

    private Function1<RpcResponseEnvelope, BoxedUnit> getOutHandler(ChannelHandlerContext ctx) {
        return (Function1)ctx.channel().attr(this.outHandlerKey()).get();
    }

    private SubprotocolEncoder encoderFor(String subprotocol) {
        SubprotocolEncoder subprotocolEncoder;
        String string = subprotocol;
        if ("jerky".equals(string)) {
            subprotocolEncoder = JerkySubprotocolEncoder$.MODULE$;
        } else if ("swanky".equals(string)) {
            subprotocolEncoder = SwankySubprotocolEncoder$.MODULE$;
        } else {
            throw new MatchError((Object)string);
        }
        return subprotocolEncoder;
    }

    private Function1<RpcResponseEnvelope, BoxedUnit> encodedOutHandler(Channel ch, SubprotocolEncoder encoder) {
        return (Function1 & Serializable & scala.Serializable)rpcResp -> {
            WebSocketFrameHandler.$anonfun$encodedOutHandler$1(ch, encoder, rpcResp);
            return BoxedUnit.UNIT;
        };
    }

    private Function1<String, BoxedUnit> encodedInHandler(Function1<RpcRequestEnvelope, BoxedUnit> inHandler, SubprotocolEncoder encoder) {
        return (Function1 & Serializable & scala.Serializable)frameText -> {
            WebSocketFrameHandler.$anonfun$encodedInHandler$1(inHandler, encoder, frameText);
            return BoxedUnit.UNIT;
        };
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        block0: {
            if (!(evt instanceof WebSocketServerProtocolHandler.HandshakeComplete)) break block0;
            WebSocketServerProtocolHandler.HandshakeComplete serverHandshakeComplete = (WebSocketServerProtocolHandler.HandshakeComplete)evt;
            String subprotocol = serverHandshakeComplete.selectedSubprotocol();
            SubprotocolEncoder encoder = this.encoderFor(subprotocol);
            Function1<RpcResponseEnvelope, BoxedUnit> outHandler = this.encodedOutHandler(ctx.channel(), encoder);
            Function1<String, BoxedUnit> inHandler = this.encodedInHandler((Function1<RpcRequestEnvelope, BoxedUnit>)((Function1)this.hookHandlers.apply(outHandler)), encoder);
            this.setInHandler(ctx, inHandler);
            this.setOutHandler(ctx, outHandler);
            this.log().info("Handlers ready");
        }
    }

    public void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) {
        WebSocketFrame webSocketFrame = frame;
        if (!(webSocketFrame instanceof TextWebSocketFrame)) {
            String message = new StringBuilder(24).append("Unsupported frame type: ").append(frame.getClass().getName()).toString();
            throw new UnsupportedOperationException(message);
        }
        TextWebSocketFrame textWebSocketFrame = (TextWebSocketFrame)webSocketFrame;
        BoxedUnit boxedUnit = (BoxedUnit)this.getInHandler(ctx).apply((Object)textWebSocketFrame.text());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable t) {
        this.log().error("Error while processing WebSocket message", t);
        RpcResponseEnvelope error = new RpcResponseEnvelope((Option)None$.MODULE$, (EnsimeServerMessage)new EnsimeServerError(t.toString()));
        this.getOutHandler(ctx).apply((Object)error);
    }

    public static final /* synthetic */ void $anonfun$encodedOutHandler$1(Channel ch$1, SubprotocolEncoder encoder$1, RpcResponseEnvelope rpcResp) {
        String response = encoder$1.writeFrame(rpcResp);
        ch$1.writeAndFlush((Object)new TextWebSocketFrame(response));
    }

    public static final /* synthetic */ void $anonfun$encodedInHandler$1(Function1 inHandler$1, SubprotocolEncoder encoder$2, String frameText) {
        RpcRequestEnvelope rpcReq = encoder$2.readFrame(frameText);
        inHandler$1.apply((Object)rpcReq);
    }

    public WebSocketFrameHandler(Function1<Function1<RpcResponseEnvelope, BoxedUnit>, Function1<RpcRequestEnvelope, BoxedUnit>> hookHandlers) {
        this.hookHandlers = hookHandlers;
        this.log = LoggerFactory.getLogger((Class)this.getClass());
        this.inHandlerKey = AttributeKey.valueOf(Function1.class, (String)"INHANDLER");
        this.outHandlerKey = AttributeKey.valueOf(Function1.class, (String)"OUTHANDLER");
    }
}

