/*
 * Decompiled with CFR 0.152.
 */
package org.ensime.util.path;

import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001e2A!\u0001\u0002\u0005\u0017\tq1i\u001c9z\t&\u0014h+[:ji>\u0014(BA\u0002\u0005\u0003\u0011\u0001\u0018\r\u001e5\u000b\u0005\u00151\u0011\u0001B;uS2T!a\u0002\u0005\u0002\r\u0015t7/[7f\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\riACF\u0007\u0002\u001d)\u0011q\u0002E\u0001\u0005M&dWM\u0003\u0002\u0012%\u0005\u0019a.[8\u000b\u0003M\tAA[1wC&\u0011QC\u0004\u0002\u0012'&l\u0007\u000f\\3GS2,g+[:ji>\u0014\bCA\u0007\u0018\u0013\tAbB\u0001\u0003QCRD\u0007\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\t\u0019\u0014x.\u001c\u0005\t9\u0001\u0011\t\u0011)A\u0005-\u0005\u0011Ao\u001c\u0005\u0006=\u0001!\taH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0001\u00123\u0005\u0005\u0002\"\u00015\t!\u0001C\u0003\u001b;\u0001\u0007a\u0003C\u0003\u001d;\u0001\u0007a\u0003C\u0003&\u0001\u0011\u0005c%A\tqe\u00164\u0016n]5u\t&\u0014Xm\u0019;pef$2a\n\u0016-!\ti\u0001&\u0003\u0002*\u001d\tya)\u001b7f-&\u001c\u0018\u000e\u001e*fgVdG\u000fC\u0003,I\u0001\u0007a#A\u0002eSJDQ!\f\u0013A\u00029\nQ!\u0019;ueN\u0004\"a\f\u001a\u000e\u0003AR!!\r\b\u0002\u0013\u0005$HO]5ckR,\u0017BA\u001a1\u0005M\u0011\u0015m]5d\r&dW-\u0011;ue&\u0014W\u000f^3t\u0011\u0015)\u0004\u0001\"\u00117\u0003%1\u0018n]5u\r&dW\rF\u0002(oaBQa\u0004\u001bA\u0002YAQ!\f\u001bA\u00029\u0002")
public class CopyDirVisitor
extends SimpleFileVisitor<Path> {
    private final Path from;
    private final Path to;

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        Path target = this.to.resolve(this.from.relativize(dir));
        Object object = Files.exists(target, new LinkOption[0]) ? BoxedUnit.UNIT : Files.createDirectory(target, new FileAttribute[0]);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        Files.copy(file, this.to.resolve(this.from.relativize(file)), StandardCopyOption.COPY_ATTRIBUTES);
        return FileVisitResult.CONTINUE;
    }

    public CopyDirVisitor(Path from, Path to) {
        this.from = from;
        this.to = to;
    }
}

