/*
 * Decompiled with CFR 0.152.
 */
package org.ensime.util.path;

import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0001\u0002\u0005\u0017\t\u0001B)\u001a7fi\u0016$\u0015N\u001d,jg&$xN\u001d\u0006\u0003\u0007\u0011\tA\u0001]1uQ*\u0011QAB\u0001\u0005kRLGN\u0003\u0002\b\u0011\u00051QM\\:j[\u0016T\u0011!C\u0001\u0004_J<7\u0001A\n\u0003\u00011\u00012!\u0004\u000b\u0017\u001b\u0005q!BA\b\u0011\u0003\u00111\u0017\u000e\\3\u000b\u0005E\u0011\u0012a\u00018j_*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u000f\u0005E\u0019\u0016.\u001c9mK\u001aKG.\u001a,jg&$xN\u001d\t\u0003\u001b]I!\u0001\u0007\b\u0003\tA\u000bG\u000f\u001b\u0005\t5\u0001\u0011\t\u0011)A\u0005-\u0005!!-Y:f\u0011\u0015a\u0002\u0001\"\u0001\u001e\u0003\u0019a\u0014N\\5u}Q\u0011a\u0004\t\t\u0003?\u0001i\u0011A\u0001\u0005\u00065m\u0001\rA\u0006\u0005\bE\u0001\u0011\r\u0011\"\u0003$\u0003\rawnZ\u000b\u0002IA\u0011Q\u0005K\u0007\u0002M)\u0011q\u0005C\u0001\u0006g24GG[\u0005\u0003S\u0019\u0012a\u0001T8hO\u0016\u0014\bBB\u0016\u0001A\u0003%A%\u0001\u0003m_\u001e\u0004\u0003\"B\u0017\u0001\t\u0003r\u0013A\u00059pgR4\u0016n]5u\t&\u0014Xm\u0019;pef$2a\f\u001a5!\ti\u0001'\u0003\u00022\u001d\tya)\u001b7f-&\u001c\u0018\u000e\u001e*fgVdG\u000fC\u00034Y\u0001\u0007a#A\u0002eSJDQ!\u000e\u0017A\u0002Y\n\u0011!\u001a\t\u0003oij\u0011\u0001\u000f\u0006\u0003sI\t!![8\n\u0005mB$aC%P\u000bb\u001cW\r\u001d;j_:DQ!\u0010\u0001\u0005By\n\u0011B^5tSR4\u0015\u000e\\3\u0015\u0007=z\u0004\tC\u0003\u0010y\u0001\u0007a\u0003C\u0003By\u0001\u0007!)A\u0003biR\u00148\u000f\u0005\u0002D\r6\tAI\u0003\u0002F\u001d\u0005I\u0011\r\u001e;sS\n,H/Z\u0005\u0003\u000f\u0012\u00131CQ1tS\u000e4\u0015\u000e\\3BiR\u0014\u0018NY;uKN\u0004")
public class DeleteDirVisitor
extends SimpleFileVisitor<Path> {
    private final Path base;
    private final Logger log;

    private Logger log() {
        return this.log;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException e) {
        try {
            Files.delete(dir);
        }
        catch (DirectoryNotEmptyException e2) {
            this.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed to delete ", " in ", " because it was not empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir, this.base})));
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        try {
            Files.delete(file);
        }
        catch (FileSystemException e) {
            this.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed to delete ", " in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file, this.base})));
        }
        return FileVisitResult.CONTINUE;
    }

    public DeleteDirVisitor(Path base) {
        this.base = base;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

