/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.javadoc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.javadoc.AbstractJavadocMojo;
import org.apache.maven.plugins.javadoc.ReverseExecutor;
import org.apache.maven.plugins.javadoc.options.OfflineLink;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;

public interface DefaultMojo {
    public static OfflineLink[] merge(OfflineLink[] a, OfflineLink[] b) {
        LinkedHashMap<String, OfflineLink> urlToOfflineLink = new LinkedHashMap<String, OfflineLink>();
        if (a != null) {
            for (OfflineLink link : a) {
                urlToOfflineLink.putIfAbsent(link.getUrl(), link);
            }
        }
        if (b != null) {
            for (OfflineLink link : b) {
                urlToOfflineLink.putIfAbsent(link.getUrl(), link);
            }
        }
        return urlToOfflineLink.values().toArray(new OfflineLink[urlToOfflineLink.size()]);
    }

    default public void setOfflineLinks(OfflineLink[] offlineLinks) {
        try {
            Field field = AbstractJavadocMojo.class.getDeclaredField("offlineLinks");
            field.setAccessible(true);
            field.set(this, DefaultMojo.merge(this.getOfflineLinks(), offlineLinks));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    default public OfflineLink[] getOfflineLinks() {
        try {
            Field field = AbstractJavadocMojo.class.getDeclaredField("offlineLinks");
            field.setAccessible(true);
            return (OfflineLink[])field.get(this);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    default public void setSourcepath(String sourcepaths) {
        try {
            Field field = AbstractJavadocMojo.class.getDeclaredField("sourcepath");
            field.setAccessible(true);
            field.set(this, sourcepaths);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    default public String getSourcepath() {
        try {
            Field field = AbstractJavadocMojo.class.getDeclaredField("sourcepath");
            field.setAccessible(true);
            return (String)field.get(this);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    default public Map<String, Collection<String>> filterSourcePaths(Map<String, Collection<String>> sourcePaths, MavenProject project) {
        String baseDir = project.getBasedir().getAbsolutePath();
        Iterator<Map.Entry<String, Collection<String>>> iterator = sourcePaths.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Collection<String>> entry = iterator.next();
            Collection<String> paths = entry.getValue();
            Iterator<String> pathsIterator = paths.iterator();
            while (pathsIterator.hasNext()) {
                String path = pathsIterator.next();
                if (path.startsWith(baseDir)) continue;
                pathsIterator.remove();
            }
            if (!paths.isEmpty()) continue;
            iterator.remove();
        }
        return sourcePaths;
    }

    default public void addGeneratedSourcePaths(MavenProject project) throws MavenReportException {
        try {
            File generatedSources = new File(project.getBuild().getDirectory(), "generated-sources");
            if (!generatedSources.exists()) {
                return;
            }
            ArrayList paths = new ArrayList();
            Files.walk(generatedSources.toPath(), new FileVisitOption[0]).filter(p -> p.getFileName().toString().endsWith(".java")).map(Path::toFile).forEach(file -> {
                String filePath = file.getParentFile().getAbsolutePath();
                int i$ = paths.size();
                for (int i = 0; i < i$; ++i) {
                    if (!filePath.startsWith((String)paths.get(i))) continue;
                    return;
                }
                boolean inBlockQuote = false;
                String packageName = null;
                try (Scanner scanner = new Scanner((File)file);){
                    scanner.useDelimiter("\r|\n");
                    while (scanner.hasNext()) {
                        String line = scanner.next().trim();
                        if (inBlockQuote) {
                            if (!line.matches("^(([^*]|(\\*[^/]))*\\*+/([^/]|(/[^*])|(/$))*)*$")) continue;
                            inBlockQuote = false;
                        }
                        if (line.length() == 0 || line.startsWith("//")) continue;
                        if (line.matches("^(([^/]|(/[^*]))*/+\\*([^*]|(\\*[^/])|(\\*$))*)*$")) {
                            inBlockQuote = true;
                            continue;
                        }
                        if (line.startsWith("package ")) {
                            packageName = line.substring(8, line.indexOf(59));
                        } else if (!(line.contains("class ") || line.contains("interface ") || line.contains("@interface "))) {
                            if (!line.contains("enum ")) continue;
                        }
                        break;
                    }
                }
                catch (FileNotFoundException e) {
                    throw new IllegalStateException(e);
                }
                if (packageName != null) {
                    paths.add(filePath.substring(0, filePath.length() - packageName.length() - 1));
                } else {
                    this.getLog().warn((CharSequence)("Could not determine package name of: " + file.getAbsolutePath()));
                }
            });
            if (paths.size() == 0) {
                return;
            }
            StringBuilder builder = new StringBuilder();
            int i$ = paths.size();
            for (int i = 0; i < i$; ++i) {
                builder.append(':').append((String)paths.get(i));
            }
            String sourcepaths = this.getSourcepath();
            if (sourcepaths == null || sourcepaths.length() == 0) {
                sourcepaths = project.getBuild().getSourceDirectory();
            }
            this.setSourcepath(sourcepaths + builder);
        }
        catch (IOException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
    }

    default public void executeReport(MavenProject project, ReverseExecutor reverseExecutor, Locale unusedLocale) {
        this.getLog().debug((CharSequence)("Submitting " + project.getName() + " " + project.getVersion()));
        reverseExecutor.submit(project, () -> {
            this.getLog().info((CharSequence)("Running " + project.getName() + " " + project.getVersion()));
            try {
                ArrayList<OfflineLink> offlineLinks = this.collectOfflineLinks();
                this.setOfflineLinks(offlineLinks.toArray(new OfflineLink[offlineLinks.size()]));
                if (this.isAggregator()) {
                    project.setExecutionRoot(true);
                }
                this.executeSuperReport(unusedLocale);
            }
            catch (MojoExecutionException | MojoFailureException | MavenReportException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public Log getLog();

    public boolean isAggregator();

    public String getApiDocsTargetPath();

    public void executeSuperReport(Locale var1) throws MavenReportException;

    public ArrayList<OfflineLink> collectOfflineLinks() throws MojoExecutionException, MojoFailureException;
}

