/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.javadoc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.javadoc.DefaultMojo;
import org.apache.maven.plugins.javadoc.JavadocReport;
import org.apache.maven.plugins.javadoc.ReverseExecutor;
import org.apache.maven.plugins.javadoc.UnpackDependencies;
import org.apache.maven.plugins.javadoc.options.OfflineLink;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.repository.RepositoryManager;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

@Mojo(name="javadoc", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
@Execute(phase=LifecyclePhase.GENERATE_SOURCES)
public class JavadocMojo
extends JavadocReport
implements DefaultMojo {
    private static final ReverseExecutor reverseExecutor = new ReverseExecutor();
    @Component
    private ArchiverManager _archiverManager;
    @Component
    private ArtifactResolver _artifactResolver;
    @Component
    private DependencyResolver _dependencyResolver;
    @Component
    private RepositoryManager _repositoryManager;
    @Component
    private ProjectBuilder _projectBuilder;
    @Component
    private ArtifactHandlerManager _artifactHandlerManager;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> _reactorProjects;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings _settings;
    @Parameter(defaultValue="${detectGeneratedSourcePaths}")
    private boolean detectGeneratedSourcePaths;

    @Override
    public boolean isAggregator() {
        return "pom".equalsIgnoreCase(this.project.getPackaging());
    }

    @Override
    public String getApiDocsTargetPath() {
        return "site/apidocs";
    }

    protected Map<String, Collection<String>> getSourcePaths() throws MavenReportException {
        return this.filterSourcePaths(super.getSourcePaths(), this.project);
    }

    @Override
    public ArrayList<OfflineLink> collectOfflineLinks() throws MojoExecutionException, MojoFailureException {
        return UnpackDependencies.execute(this, this._settings, this.project, this.session, this._reactorProjects, this._archiverManager, this._artifactResolver, this._dependencyResolver, this._repositoryManager, this._projectBuilder, this._artifactHandlerManager);
    }

    @Override
    public void executeSuperReport(Locale unusedLocale) throws MavenReportException {
        super.executeReport(unusedLocale);
    }

    protected void executeReport(Locale unusedLocale) throws MavenReportException {
        if (this.detectGeneratedSourcePaths) {
            this.addGeneratedSourcePaths(this.project);
        }
        this.executeReport(this.project, reverseExecutor, unusedLocale);
    }
}

