/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.javadoc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

final class MojoUtil {
    private static final int BUFFER_SIZE = 4096;
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int downloadFile(String url, File file) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(3000);
        try {
            connection.setIfModifiedSince(file.lastModified());
            int responseCode = connection.getResponseCode();
            if (responseCode != 304 && responseCode == 200) {
                try (InputStream in = connection.getInputStream();
                     FileOutputStream out = new FileOutputStream(file);){
                    int read;
                    byte[] buffer = new byte[4096];
                    while ((read = in.read(buffer)) != -1) {
                        out.write(buffer, 0, read);
                    }
                }
            }
            int n = responseCode;
            return n;
        }
        finally {
            connection.disconnect();
        }
    }

    static Model getModelArtifact(File pomFile) {
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((Reader)new FileReader(pomFile));
            model.setPomFile(pomFile);
            return model;
        }
        catch (IOException | XmlPullParserException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String getId(Model model) {
        String groupId = model.getGroupId() != null ? model.getGroupId() : model.getParent().getGroupId();
        String version = model.getVersion() != null ? model.getVersion() : model.getParent().getVersion();
        return groupId + ":" + model.getArtifactId() + ":" + version;
    }

    private static String getParentPath(String localRepoPath, Parent parent) {
        String artifactPath = parent.getGroupId().replace('.', '/') + "/" + parent.getArtifactId() + "/" + parent.getVersion() + "/";
        String parentPath = localRepoPath + artifactPath;
        return MojoUtil.getModelUrl(new File(parentPath, parent.getArtifactId() + "-" + parent.getVersion() + ".pom"));
    }

    static String getModelUrl(File pomFile) {
        Model model = MojoUtil.getModelArtifact(pomFile);
        String url = MojoUtil.cleanUrl(model.getUrl());
        if (url != null) {
            return url;
        }
        String id = MojoUtil.getId(model);
        String artifactDir = pomFile.getParent();
        String localRepoPath = artifactDir.substring(0, artifactDir.length() - id.length());
        String parentUrl = MojoUtil.getParentPath(localRepoPath, model.getParent());
        return parentUrl + model.getArtifactId() + "/";
    }

    static void checkPackageList(String destDir) throws IOException {
        File elementListFile;
        File packageListFile = new File(destDir, "package-list");
        if (!packageListFile.exists() && (elementListFile = new File(destDir, "element-list")).exists()) {
            FileUtils.copyFile((File)elementListFile, (File)packageListFile);
        }
    }

    static boolean exists(String url) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(3000);
            connection.connect();
            connection.disconnect();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    static void setField(Class<?> cls, AbstractMojo mojo, String name, Object value) {
        try {
            Field field = cls.getDeclaredField(name);
            field.setAccessible(true);
            field.set(mojo, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String cleanUrl(String url) {
        if (url == null) {
            return null;
        }
        url = url.trim();
        while (url.endsWith("/")) {
            url = url.substring(0, url.lastIndexOf(47));
        }
        return url + "/";
    }

    static String getJavadocLink(MavenProject project) {
        return project.getUrl() == null ? null : MojoUtil.cleanUrl(project.getUrl()) + "/apidocs";
    }

    private MojoUtil() {
    }
}

