/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.javadoc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.project.MavenProject;

public class ReverseExecutor {
    private final Module rootModule = new Module();
    private String rootDir;

    public void submit(MavenProject project, Runnable runnable) {
        Module module = new Module(project, runnable);
        String parentPath = project.hasParent() && project.getParent().getBasedir() != null ? project.getParent().getBasedir().getAbsolutePath() : project.getBasedir().getParentFile().getAbsolutePath();
        if (this.rootDir == null) {
            this.rootDir = parentPath + "/";
        }
        Module parent = parentPath.length() <= this.rootDir.length() ? this.rootModule : this.rootModule.getModule(parentPath.substring(this.rootDir.length()));
        parent.addModule(module);
        if (project.getModules().isEmpty()) {
            parent.removeModule(project.getBasedir().getName());
        }
    }

    private class Module {
        private final Map<String, Module> modules = new HashMap<String, Module>();
        private final MavenProject project;
        private final Runnable runnable;
        private final String name;
        private Module parent;

        private Module(MavenProject project, Runnable runnable) {
            this.project = Objects.requireNonNull(project);
            this.runnable = runnable;
            this.name = project.hasParent() && project.getParent().getBasedir() != null && project.getBasedir().getAbsolutePath().startsWith(project.getParent().getBasedir().getAbsolutePath()) ? project.getBasedir().getAbsolutePath().substring(project.getParent().getBasedir().getAbsolutePath().length() + 1) : project.getBasedir().getName();
            List modules = project.getModules();
            if (modules.size() > 0) {
                for (String module : modules) {
                    this.modules.put(module, null);
                }
            }
        }

        private Module() {
            this.project = null;
            this.runnable = null;
            this.name = null;
        }

        private void addModule(Module module) {
            if (this.project != null && !this.modules.containsKey(module.name)) {
                throw new IllegalStateException("Module not found: " + module.name + " in " + this.modules.keySet());
            }
            if (module.parent != null) {
                throw new IllegalStateException("Parent was already set");
            }
            module.parent = this;
            this.modules.put(module.name, module);
        }

        private Module processModule(String qualifiedName, boolean remove) {
            String name = qualifiedName;
            while (true) {
                Module module;
                Module module2 = module = remove ? this.modules.remove(name) : this.modules.get(name);
                if (module != null) {
                    if (name.equals(qualifiedName)) {
                        if (remove) {
                            if (module.modules.size() > 0) {
                                throw new IllegalStateException("Expected to remove empty sub-module");
                            }
                            module.runnable.run();
                            if (this.parent != null && this.modules.size() == 0) {
                                this.parent.removeModule(this.name);
                            }
                        }
                        return module;
                    }
                    return module.processModule(qualifiedName.substring(name.length() + 1), remove);
                }
                int slash = name.lastIndexOf(47);
                if (slash == -1) {
                    throw new IllegalStateException("Module (qualified '" + qualifiedName + "') not found: " + name + " in " + this.modules.keySet());
                }
                name = name.substring(0, slash);
            }
        }

        public Module removeModule(String qualifiedName) {
            return this.processModule(qualifiedName, true);
        }

        public Module getModule(String qualifiedName) {
            return this.processModule(qualifiedName, false);
        }

        public String toString() {
            return this.name + ": " + this.modules;
        }
    }
}

