/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.javadoc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.dependency.AbstractDependencyMojo;
import org.apache.maven.plugins.dependency.fromDependencies.AbstractDependencyFilterMojo;
import org.apache.maven.plugins.dependency.fromDependencies.UnpackDependenciesMojo;
import org.apache.maven.plugins.dependency.utils.DependencyStatusSets;
import org.apache.maven.plugins.javadoc.DefaultMojo;
import org.apache.maven.plugins.javadoc.FilterLog;
import org.apache.maven.plugins.javadoc.MojoUtil;
import org.apache.maven.plugins.javadoc.options.OfflineLink;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.repository.RepositoryManager;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

class UnpackDependencies
extends UnpackDependenciesMojo {
    private static final HashMap<Artifact, Set<OfflineLink>> artifactToOfflineLinks = new HashMap();
    private static final HashMap<Artifact, OfflineLink> artifactToDependencyLink = new HashMap();
    private static final boolean reportError;
    private final DefaultMojo mojo;
    private final Set<OfflineLink> offlineLinks;
    private final boolean offline;
    private final MavenProject project;

    static ArrayList<OfflineLink> execute(DefaultMojo mojo, Settings settings, MavenProject project, MavenSession session, List<MavenProject> reactorProjects, ArchiverManager archiverManager, ArtifactResolver artifactResolver, DependencyResolver dependencyResolver, RepositoryManager repositoryManager, ProjectBuilder projectBuilder, ArtifactHandlerManager artifactHandlerManager) throws MojoExecutionException, MojoFailureException {
        UnpackDependencies unpackDependencies = new UnpackDependencies(mojo, settings, project, session, reactorProjects, archiverManager, artifactResolver, dependencyResolver, repositoryManager, projectBuilder, artifactHandlerManager);
        unpackDependencies.execute();
        ArrayList<OfflineLink> offlineLinks = new ArrayList<OfflineLink>(unpackDependencies.offlineLinks);
        offlineLinks.remove(0);
        Log log = mojo.getLog();
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)"Detected offline links...");
            int i$ = offlineLinks.size();
            for (int i = 0; i < i$; ++i) {
                OfflineLink offlineLink = offlineLinks.get(i);
                for (String line : offlineLink.toString().split("\n")) {
                    log.debug((CharSequence)line);
                }
            }
        }
        return offlineLinks;
    }

    private UnpackDependencies(DefaultMojo mojo, Settings settings, MavenProject project, MavenSession session, List<MavenProject> reactorProjects, ArchiverManager archiverManager, ArtifactResolver artifactResolver, DependencyResolver dependencyResolver, RepositoryManager repositoryManager, ProjectBuilder projectBuilder, ArtifactHandlerManager artifactHandlerManager) {
        this.mojo = mojo;
        this.setLog(new FilterLog(mojo.getLog()){

            @Override
            public boolean isInfoEnabled() {
                return false;
            }
        });
        this.offlineLinks = this.addModules(MojoUtil.getModelArtifact(new File(project.getBasedir(), "pom.xml")));
        this.offline = settings.isOffline();
        this.project = project;
        this.session = session;
        MojoUtil.setField(AbstractDependencyMojo.class, (AbstractMojo)this, "remoteRepositories", project.getRemoteArtifactRepositories());
        this.reactorProjects = reactorProjects;
        this.setArchiverManager(archiverManager);
        MojoUtil.setField(AbstractDependencyFilterMojo.class, (AbstractMojo)this, "artifactResolver", artifactResolver);
        MojoUtil.setField(AbstractDependencyFilterMojo.class, (AbstractMojo)this, "dependencyResolver", dependencyResolver);
        MojoUtil.setField(AbstractDependencyFilterMojo.class, (AbstractMojo)this, "repositoryManager", repositoryManager);
        MojoUtil.setField(AbstractDependencyFilterMojo.class, (AbstractMojo)this, "projectBuilder", projectBuilder);
        MojoUtil.setField(AbstractDependencyFilterMojo.class, (AbstractMojo)this, "artifactHandlerManager", artifactHandlerManager);
        this.failOnMissingClassifierArtifact = false;
        this.classifier = "javadoc";
        this.outputDirectory = new File(settings.getLocalRepository());
        this.markersDirectory = new File(settings.getLocalRepository(), "dependency-maven-plugin-markers");
    }

    private Set<OfflineLink> addModules(Model model) {
        DefaultArtifact artifact = new DefaultArtifact(model.getGroupId() != null ? model.getGroupId() : model.getParent().getGroupId(), model.getArtifactId(), model.getVersion() != null ? model.getVersion() : model.getParent().getVersion(), "compile", "jar", null, (ArtifactHandler)new DefaultArtifactHandler());
        Set<OfflineLink> links = artifactToOfflineLinks.get(artifact);
        if (links != null) {
            return links;
        }
        if ("pom".equalsIgnoreCase(model.getPackaging())) {
            LinkedHashSet<OfflineLink> moduleLinks;
            List modules = model.getModules();
            if (modules.size() == 0) {
                moduleLinks = Collections.EMPTY_SET;
            } else {
                moduleLinks = new LinkedHashSet<OfflineLink>();
                for (String module : modules) {
                    File path = new File(model.getProjectDirectory(), module);
                    Model submodule = MojoUtil.getModelArtifact(new File(path, "pom.xml"));
                    moduleLinks.addAll(this.addModules(submodule));
                }
            }
            artifactToOfflineLinks.put((Artifact)artifact, moduleLinks);
            return moduleLinks;
        }
        OfflineLink offlineLink = new OfflineLink();
        offlineLink.setUrl(this.getJavadocIoLink((Artifact)artifact));
        File apiDocs = new File(model.getPomFile().getParentFile(), "target/" + this.mojo.getApiDocsTargetPath() + "/");
        offlineLink.setLocation(apiDocs.getAbsolutePath());
        LinkedHashSet<OfflineLink> moduleLinks = new LinkedHashSet<OfflineLink>();
        moduleLinks.add(offlineLink);
        artifactToOfflineLinks.put((Artifact)artifact, moduleLinks);
        return moduleLinks;
    }

    public MavenProject getProject() {
        return this.project;
    }

    private static String getJavadocLink(Artifact artifact) {
        String filePath = artifact.getFile().toString();
        if (!filePath.endsWith("-javadoc.jar")) {
            return null;
        }
        return MojoUtil.getModelUrl(new File(filePath.substring(filePath.length() - 12) + ".pom")) + "apidocs/";
    }

    private String getJavadocIoLink(Artifact artifact) {
        String version = artifact.getVersion().replace("-SNAPSHOT", "");
        String url = "https://static.javadoc.io/" + artifact.getGroupId() + "/" + artifact.getArtifactId() + "/" + version + "/";
        if (!this.offline && !MojoUtil.exists(url + "index.html")) {
            MojoUtil.exists("https://www.javadoc.io/doc/" + artifact.getGroupId() + "/" + artifact.getArtifactId() + "/" + version + "/");
        }
        return url;
    }

    private boolean downloadPackageList(String docUrl, File file) {
        if (docUrl == null) {
            return false;
        }
        try {
            docUrl = docUrl + "package-list";
            int responseCode = MojoUtil.downloadFile(docUrl, file);
            if (responseCode == 304) {
                this.getLog().debug((CharSequence)("Not Modified: " + docUrl));
            }
            return true;
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (!message.contains(docUrl)) {
                message = message + ": " + docUrl;
            }
            if (reportError) {
                this.getLog().warn((CharSequence)message, (Throwable)e);
            } else {
                this.getLog().warn((CharSequence)message);
            }
            return false;
        }
    }

    private void addDependency(Artifact artifact, boolean resolved) {
        Set<OfflineLink> offlineLinks = artifactToOfflineLinks.get(artifact);
        if (offlineLinks != null) {
            this.offlineLinks.addAll(offlineLinks);
        } else {
            OfflineLink dependencyLink = artifactToDependencyLink.get(artifact);
            if (dependencyLink == null) {
                File destDir = this.getFormattedOutputDirectory(artifact);
                dependencyLink = new OfflineLink();
                dependencyLink.setUrl(this.getJavadocIoLink(artifact));
                dependencyLink.setLocation(destDir.getAbsolutePath());
                if (!resolved) {
                    destDir.mkdirs();
                    File packageListFile = new File(destDir, "package-list");
                    if (!this.downloadPackageList(this.getJavadocIoLink(artifact), packageListFile) && !this.downloadPackageList(UnpackDependencies.getJavadocLink(artifact), packageListFile)) {
                        this.getLog().error((CharSequence)("Unable to resolve dependency: " + artifact.getId()));
                        return;
                    }
                }
                artifactToDependencyLink.put(artifact, dependencyLink);
            }
            this.offlineLinks.add(dependencyLink);
        }
    }

    private File getFormattedOutputDirectory(Artifact artifact) {
        StringBuilder builder = new StringBuilder(128);
        builder.append(artifact.getGroupId().replace('.', File.separatorChar)).append(File.separatorChar);
        builder.append(artifact.getArtifactId()).append(File.separatorChar);
        builder.append(artifact.getBaseVersion()).append(File.separatorChar);
        builder.append("javadoc").append(File.separatorChar);
        return new File(this.outputDirectory, builder.toString());
    }

    protected DependencyStatusSets getDependencySets(boolean stopOnFailure) throws MojoExecutionException {
        Set resolvedDependencies;
        DependencyStatusSets dependencyStatusSets = super.getDependencySets(stopOnFailure);
        Set unResolvedDependencies = dependencyStatusSets.getUnResolvedDependencies();
        if (unResolvedDependencies.size() > 0) {
            for (Artifact artifact : unResolvedDependencies) {
                this.addDependency(artifact, false);
            }
        }
        if ((resolvedDependencies = dependencyStatusSets.getResolvedDependencies()).size() > 0) {
            for (Artifact artifact : resolvedDependencies) {
                this.addDependency(artifact, true);
            }
        }
        return dependencyStatusSets;
    }

    protected void unpack(Artifact artifact, File location, String includes, String excludes, String encoding) throws MojoExecutionException {
        super.unpack(artifact, this.getFormattedOutputDirectory(artifact), includes, excludes, encoding);
    }

    protected void doExecute() throws MojoExecutionException {
        super.doExecute();
        if (this.offlineLinks.size() > 0) {
            try {
                for (OfflineLink offlineLink : this.offlineLinks) {
                    MojoUtil.checkPackageList(offlineLink.getLocation());
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
    }

    static {
        String sunJavaCommand = System.getProperty("sun.java.command") + " ";
        reportError = sunJavaCommand.contains(" -e ") || sunJavaCommand.contains(" --error ");
        System.setProperty("https.protocols", "TLSv1.2,TLSv1.1,SSLv3");
        System.setProperty("http.agent", "");
    }
}

