/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca;

import com.lmax.disruptor.dsl.Disruptor;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.epics.ca.AccessRights;
import org.epics.ca.ConnectionState;
import org.epics.ca.Listener;
import org.epics.ca.Monitor;
import org.epics.ca.Status;
import org.epics.ca.data.Metadata;
import org.epics.ca.util.Holder;

public interface Channel<T>
extends AutoCloseable {
    public static final int MONITOR_QUEUE_SIZE_DEFAULT = 2;

    public String getName();

    public ConnectionState getConnectionState();

    public AccessRights getAccessRights();

    public Channel<T> connect();

    public CompletableFuture<Channel<T>> connectAsync();

    public Listener addConnectionListener(BiConsumer<Channel<T>, Boolean> var1);

    public Listener addAccessRightListener(BiConsumer<Channel<T>, AccessRights> var1);

    public T get();

    public void put(T var1);

    public void putNoWait(T var1);

    public CompletableFuture<T> getAsync();

    public CompletableFuture<Status> putAsync(T var1);

    public <MT extends Metadata<T>> MT get(Class<? extends Metadata> var1);

    public <MT extends Metadata<T>> CompletableFuture<MT> getAsync(Class<? extends Metadata> var1);

    default public Monitor<T> addValueMonitor(Consumer<? super T> handler) {
        return this.addValueMonitor(handler, 2, 1);
    }

    public Monitor<T> addValueMonitor(Consumer<? super T> var1, int var2, int var3);

    default public <MT extends Metadata<T>> Monitor<MT> addMonitor(Class<? extends Metadata> clazz, Consumer<MT> handler) {
        return this.addMonitor(clazz, handler, 2, 1);
    }

    public <MT extends Metadata<T>> Monitor<MT> addMonitor(Class<? extends Metadata> var1, Consumer<MT> var2, int var3, int var4);

    public Monitor<T> addValueMonitor(Disruptor<Holder<T>> var1, int var2);

    public <MT extends Metadata<T>> Monitor<MT> addMonitor(Class<? extends Metadata> var1, Disruptor<Holder<MT>> var2, int var3);

    public Map<String, Object> getProperties();

    @Override
    public void close();
}

