/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.epics.ca.Channel;
import org.epics.ca.ChannelDescriptor;
import org.epics.ca.Context;
import org.epics.ca.Monitor;
import org.epics.ca.annotation.CaChannel;

public class Channels {
    public static <T> void waitForValue(Channel<T> channel, T value) {
        try {
            Channels.waitForValueAsync(channel, value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void waitForValue(Channel<T> channel, T value, Comparator<T> comparator) {
        try {
            Channels.waitForValueAsync(channel, value, comparator).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> CompletableFuture<T> waitForValueAsync(Channel<T> channel, T value) {
        Comparator comparator = new Comparator<T>(){

            @Override
            public int compare(T o, T o2) {
                if (o.equals(o2)) {
                    return 0;
                }
                return -1;
            }
        };
        return Channels.waitForValueAsync(channel, value, comparator);
    }

    public static <T> CompletableFuture<T> waitForValueAsync(Channel<T> channel, T value, Comparator<T> comparator) {
        CompletableFuture future = new CompletableFuture();
        Monitor<Object> monitor = channel.addValueMonitor(newValue -> {
            if (comparator.compare(newValue, value) == 0) {
                future.complete(newValue);
            }
        });
        return future.whenComplete((v, exception) -> monitor.close());
    }

    public static Channel<?> create(Context context, String name) {
        return Channels.create(context, name, Object.class);
    }

    public static <T> Channel<T> create(Context context, String name, Class<T> type) {
        Channel<T> channel = context.createChannel(name, type);
        channel.connect();
        return channel;
    }

    public static <T> Channel<T> create(Context context, ChannelDescriptor<T> descriptor) {
        Channel<T> channel = context.createChannel(descriptor.getName(), descriptor.getType());
        channel.connect();
        return channel;
    }

    public static List<Channel<?>> create(Context context, List<ChannelDescriptor<?>> descriptors) {
        ArrayList channels = new ArrayList(descriptors.size());
        ArrayList futures = new ArrayList(descriptors.size());
        for (ChannelDescriptor<?> descriptor : descriptors) {
            Channel<?> channel = context.createChannel(descriptor.getName(), descriptor.getType());
            channels.add(channel);
            futures.add(channel.connectAsync());
        }
        try {
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return channels;
    }

    public static void create(Context context, Object object) {
        Channels.create(context, object, new HashMap<String, String>());
    }

    public static void create(Context context, Object object, Map<String, String> macros) {
        try {
            Class<?> c = object.getClass();
            ArrayList<Field> fieldList = new ArrayList<Field>();
            HashMap<Field, Integer> sizeMap = new HashMap<Field, Integer>();
            ArrayList descriptorList = new ArrayList();
            for (Field field : c.getDeclaredFields()) {
                CaChannel annotation = field.getAnnotation(CaChannel.class);
                if (annotation == null) continue;
                if (annotation.name().length == 1 && field.getType().isAssignableFrom(Channel.class)) {
                    fieldList.add(field);
                    sizeMap.put(field, 1);
                    descriptorList.add(new ChannelDescriptor(Channels.format(annotation.name()[0], macros), annotation.type(), annotation.monitor()));
                    continue;
                }
                if (annotation.name().length > 0 && field.getType().isAssignableFrom(List.class)) {
                    fieldList.add(field);
                    sizeMap.put(field, annotation.name().length);
                    for (String n : annotation.name()) {
                        descriptorList.add(new ChannelDescriptor(Channels.format(n, macros), annotation.type(), annotation.monitor()));
                    }
                    continue;
                }
                throw new RuntimeException("Annotation @" + CaChannel.class.getSimpleName() + " not applicable for field '" + field.getName() + "' of type '" + field.getType().getName() + "'");
            }
            List<Channel<?>> channelList = Channels.create(context, descriptorList);
            int ccount = 0;
            for (int fc = 0; fc < fieldList.size(); ++fc) {
                Field f = (Field)fieldList.get(fc);
                boolean accessible = f.isAccessible();
                f.setAccessible(true);
                int fsize = (Integer)sizeMap.get(f);
                if (fsize == 1 && f.getType().isAssignableFrom(Channel.class)) {
                    f.set(object, channelList.get(ccount));
                    ++ccount;
                } else {
                    ArrayList list = new ArrayList();
                    for (int i = 0; i < (Integer)sizeMap.get(f); ++i) {
                        list.add(channelList.get(ccount));
                        ++ccount;
                    }
                    f.set(object, list);
                }
                f.setAccessible(accessible);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void close(Object object) {
        try {
            Class<?> c = object.getClass();
            for (Field field : c.getDeclaredFields()) {
                boolean accessible;
                CaChannel annotation = field.getAnnotation(CaChannel.class);
                if (annotation == null) continue;
                if (field.getType().isAssignableFrom(Channel.class)) {
                    accessible = field.isAccessible();
                    field.setAccessible(true);
                    ((Channel)field.get(object)).close();
                    field.set(object, null);
                    field.setAccessible(accessible);
                    continue;
                }
                if (field.getType().isAssignableFrom(List.class)) {
                    accessible = field.isAccessible();
                    field.setAccessible(true);
                    List l = (List)field.get(object);
                    for (Channel b : l) {
                        b.close();
                    }
                    field.set(object, null);
                    field.setAccessible(accessible);
                    continue;
                }
                throw new RuntimeException("Annotation @" + CaChannel.class.getSimpleName() + " not applicable for field '" + field.getName() + "' of type '" + field.getType().getName() + "'");
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static String format(String formatString, Map<String, String> macros) {
        if (macros.isEmpty()) {
            return formatString;
        }
        String fieldStart = "\\$\\{";
        String fieldEnd = "\\}";
        String regex = "\\$\\{([^}]+)\\}";
        Pattern pattern = Pattern.compile("\\$\\{([^}]+)\\}");
        Matcher m = pattern.matcher(formatString);
        String result = formatString;
        while (m.find()) {
            String ma = m.group(1);
            String replacement = macros.get(ma);
            if (replacement == null) {
                replacement = "\\$\\{" + ma + "\\}";
            }
            result = result.replaceFirst("\\$\\{" + ma + "\\}", replacement);
        }
        return result;
    }
}

