/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.reactor.lf;

import java.nio.channels.SelectionKey;
import org.epics.ca.impl.reactor.Reactor;
import org.epics.ca.impl.reactor.ReactorHandler;
import org.epics.ca.impl.reactor.lf.LeaderFollowersThreadPool;

public class LeaderFollowersHandler
implements ReactorHandler,
Runnable {
    protected Reactor reactor;
    protected ReactorHandler handler;
    protected LeaderFollowersThreadPool threadPool;

    public LeaderFollowersHandler(Reactor reactor, ReactorHandler handler, LeaderFollowersThreadPool threadPool) {
        this.reactor = reactor;
        this.handler = handler;
        this.threadPool = threadPool;
    }

    @Override
    public void handleEvent(SelectionKey key) {
        if (!key.isValid()) {
            this.threadPool.promoteLeader(this);
            return;
        }
        this.reactor.disableSelectionKey(key);
        try {
            this.threadPool.promoteLeader(this);
            this.handler.handleEvent(key);
        }
        finally {
            this.reactor.enableSelectionKey(key);
        }
    }

    @Override
    public void run() {
        this.reactor.process();
    }
}

