/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.reactor.lf;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LeaderFollowersThreadPool {
    private static final Logger logger = Logger.getLogger(LeaderFollowersThreadPool.class.getName());
    public static final int DEFAULT_THREADPOOL_SIZE = 5;
    private volatile boolean shutdown = false;
    private ThreadPoolExecutor executor;

    public LeaderFollowersThreadPool() {
        int threadPoolSize = 5;
        String strVal = System.getProperty(this.getClass().getName() + ".thread_pool_size", String.valueOf(threadPoolSize));
        if (strVal != null) {
            try {
                threadPoolSize = Math.max(2, Integer.parseInt(strVal));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.executor = new ThreadPoolExecutor(threadPoolSize, threadPoolSize, Long.MAX_VALUE, TimeUnit.NANOSECONDS, new LinkedBlockingQueue<Runnable>());
        this.executor.prestartAllCoreThreads();
    }

    public void promoteLeader(Runnable task) {
        this.execute(task);
    }

    public void execute(Runnable task) {
        try {
            this.executor.execute(task);
        }
        catch (Throwable th) {
            logger.log(Level.SEVERE, "Unexpected exception caught in one of the LF thread-pool thread.", th);
        }
    }

    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

