/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.requests;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.epics.ca.CompletionException;
import org.epics.ca.Status;
import org.epics.ca.impl.ChannelImpl;
import org.epics.ca.impl.ContextImpl;
import org.epics.ca.impl.Messages;
import org.epics.ca.impl.NotifyResponseRequest;
import org.epics.ca.impl.Transport;
import org.epics.ca.impl.TypeSupports;

public class ReadNotifyRequest<T>
extends CompletableFuture<T>
implements NotifyResponseRequest {
    protected final ContextImpl context;
    protected final int ioid;
    protected final int sid;
    protected final ChannelImpl<?> channel;
    protected final TypeSupports.TypeSupport<T> typeSupport;

    public ReadNotifyRequest(ChannelImpl<?> channel, Transport transport, int sid, TypeSupports.TypeSupport<T> typeSupport) {
        this.channel = channel;
        this.sid = sid;
        this.typeSupport = typeSupport;
        int dataCount = typeSupport.getForcedElementCount();
        if (dataCount == 0 && channel.getTransport().getMinorRevision() < 13) {
            dataCount = channel.getNativeElementCount();
        }
        this.context = transport.getContext();
        this.ioid = this.context.registerResponseRequest(this);
        channel.registerResponseRequest(this);
        Messages.readNotifyMessage(transport, typeSupport.getDataType(), dataCount, sid, this.ioid);
        transport.flush();
    }

    @Override
    public int getIOID() {
        return this.ioid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void response(int status, short dataType, int dataCount, ByteBuffer dataPayloadBuffer) {
        try {
            Status caStatus = Status.forStatusCode(status);
            if (caStatus == Status.NORMAL) {
                Object value = null;
                value = this.typeSupport.deserialize(dataPayloadBuffer, value, dataCount);
                this.complete(value);
            } else {
                this.completeExceptionally(caStatus, caStatus.getMessage());
            }
        }
        finally {
            this.cancel();
        }
    }

    @Override
    public void cancel() {
        this.context.unregisterResponseRequest(this);
        this.channel.unregisterResponseRequest(this);
    }

    @Override
    public void exception(int errorCode, String errorMessage) {
        this.cancel();
        Status status = Status.forStatusCode(errorCode);
        if (status == null) {
            status = Status.GETFAIL;
        }
        this.completeExceptionally(status, errorMessage);
    }

    protected void completeExceptionally(Status status, String message) {
        this.completeExceptionally(new CompletionException(status, message));
    }
}

