/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.util;

import java.lang.reflect.Array;
import java.util.ArrayList;

public class IntHashMap<T> {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient EntryObjectPool pool;

    public IntHashMap() {
        this(20, 0.75f);
    }

    public IntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
        this.pool = new EntryObjectPool(initialCapacity);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsValue(T value) {
        return this.contains(value);
    }

    public boolean containsKey(int key) {
        Entry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public T get(int key) {
        Entry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash) {
                return (T)e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public Object put(int key, T value) {
        Entry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = this.pool.getEntry(hash, key, value, tab[index]);
        ++this.count;
        return null;
    }

    public T remove(int key) {
        Entry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e.hash == hash) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                e.next = null;
                this.pool.putEntry(e);
                return (T)oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public void clear() {
        Entry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            Entry e = tab[index];
            if (e != null) {
                e.value = null;
                e.next = null;
                this.pool.putEntry(e);
            }
            tab[index] = null;
        }
        this.count = 0;
    }

    public T[] toArray(T[] arr) {
        if (arr == null || arr.length < this.count) {
            arr = (Object[])Array.newInstance(arr.getClass().getComponentType(), this.count);
        }
        int pos = 0;
        Entry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            while (e != null) {
                arr[pos++] = e.value;
                e = e.next;
            }
        }
        return arr;
    }

    private static class EntryObjectPool {
        private ArrayList<Entry> pool;
        private int lastPos = -1;

        public EntryObjectPool(int initialCapacity) {
            this.pool = new ArrayList(initialCapacity);
        }

        public Entry getEntry(int hash, int key, Object value, Entry next) {
            if (this.lastPos == -1) {
                return new Entry(hash, key, value, next);
            }
            Entry entry = this.pool.remove(this.lastPos--);
            entry.initialize(hash, key, value, next);
            return entry;
        }

        public void putEntry(Entry entry) {
            this.pool.add(entry);
            ++this.lastPos;
        }
    }

    private static class Entry {
        int hash;
        Object value;
        Entry next;

        protected Entry(int hash, int key, Object value, Entry next) {
            this.initialize(hash, key, value, next);
        }

        public void initialize(int hash, int key, Object value, Entry next) {
            this.hash = hash;
            this.value = value;
            this.next = next;
        }
    }
}

