/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl;

import java.net.InetSocketAddress;
import org.epics.ca.impl.ContextImpl;

public class BeaconHandler {
    private final ContextImpl context;
    private long averagePeriod = Long.MIN_VALUE;
    private boolean periodStabilized = false;
    private long lastBeaconSequenceID;
    private long lastBeaconTimeStamp = Long.MIN_VALUE;

    public BeaconHandler(ContextImpl context, InetSocketAddress responseFrom) {
        this.context = context;
    }

    public void beaconNotify(short remoteTransportRevision, long timestamp, long sequentialID) {
        boolean networkChanged = this.updateBeaconPeriod(remoteTransportRevision, timestamp, sequentialID);
        if (networkChanged) {
            // empty if block
        }
    }

    private synchronized boolean updateBeaconPeriod(short remoteTransportRevision, long timestamp, long sequentialID) {
        if (this.lastBeaconTimeStamp == Long.MIN_VALUE) {
            this.context.beaconAnomalyNotify();
            if (remoteTransportRevision >= 10) {
                this.lastBeaconSequenceID = sequentialID;
            }
            this.lastBeaconTimeStamp = timestamp;
            return false;
        }
        if (remoteTransportRevision >= 10) {
            long beaconSeqAdvance = sequentialID >= this.lastBeaconSequenceID ? sequentialID - this.lastBeaconSequenceID : 0xFFFFFFFFL - this.lastBeaconSequenceID + sequentialID;
            this.lastBeaconSequenceID = sequentialID;
            if (beaconSeqAdvance == 0L || beaconSeqAdvance > 0xFFFFFEFFL) {
                return false;
            }
            if (beaconSeqAdvance > 1L && beaconSeqAdvance < 4L) {
                return false;
            }
        }
        boolean networkChange = false;
        long currentPeriod = timestamp - this.lastBeaconTimeStamp;
        if (this.averagePeriod < 0L) {
            this.averagePeriod = currentPeriod;
        } else {
            if ((double)currentPeriod >= (double)this.averagePeriod * 1.25) {
                if ((double)currentPeriod >= (double)this.averagePeriod * 3.25) {
                    this.context.beaconAnomalyNotify();
                    networkChange = true;
                } else if (!this.periodStabilized) {
                    this.averagePeriod = currentPeriod;
                } else {
                    this.context.beaconAnomalyNotify();
                }
            } else if ((double)currentPeriod <= (double)this.averagePeriod * 0.8) {
                this.context.beaconAnomalyNotify();
                networkChange = true;
            } else {
                this.periodStabilized = true;
            }
            if (networkChange) {
                this.periodStabilized = false;
                this.averagePeriod = -1L;
            } else {
                this.averagePeriod = (long)((double)currentPeriod * 0.125 + (double)this.averagePeriod * 0.875);
            }
        }
        this.lastBeaconTimeStamp = timestamp;
        return networkChange;
    }
}

