/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.monitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;
import org.epics.ca.impl.monitor.MonitorNotificationServiceFactory;
import org.epics.ca.impl.monitor.blockingqueue.BlockingQueueMonitorNotificationServiceFactory;
import org.epics.ca.impl.monitor.disruptor.DisruptorMonitorNotificationServiceFactory;
import org.epics.ca.impl.monitor.striped.StripedExecutorServiceMonitorNotificationServiceFactory;

public class MonitorNotificationServiceFactoryCreator
implements AutoCloseable {
    public static final String V1_1_0_DEFAULT_IMPL = ServiceImpl.BlockingQueueMultipleWorkerMonitorNotificationServiceImpl.name() + ",5";
    public static final String DEFAULT_IMPL = ServiceImpl.BlockingQueueMultipleWorkerMonitorNotificationServiceImpl.name() + ",16";
    public static final String HUMAN_CONSUMER_IMPL = (Object)((Object)ServiceImpl.BlockingQueueMultipleWorkerMonitorNotificationServiceImpl) + ",100,1";
    public static final String MACHINE_CONSUMER_IMPL = ServiceImpl.BlockingQueueMultipleWorkerMonitorNotificationServiceImpl.name() + ",100";
    public static final int NUMBER_OF_SERVICE_THREADS_DEFAULT = 10;
    public static final int NOTIFICATION_VALUE_BUFFER_SIZE_DEFAULT = Integer.MAX_VALUE;
    private static final Logger logger = Logger.getLogger(MonitorNotificationServiceFactoryCreator.class.getName());
    private static final List<MonitorNotificationServiceFactory> serviceFactoryList = new ArrayList<MonitorNotificationServiceFactory>();

    public static MonitorNotificationServiceFactory create(String serviceConfiguration) {
        MonitorNotificationServiceFactory serviceFactory;
        logger.log(Level.FINEST, String.format("MonitorNotificationServiceFactoryCreator has been called with serviceImpl specifier: %s", serviceConfiguration));
        Validate.notEmpty((CharSequence)serviceConfiguration);
        String[] args = serviceConfiguration.split(",");
        Validate.isTrue((args.length >= 1 ? 1 : 0) != 0);
        Validate.isTrue((boolean)ServiceImpl.isRecognised(args[0]), (String)("The service configuration '" + args[0] + "' was not recognised."), (Object[])new Object[0]);
        ServiceImpl serviceImpl = ServiceImpl.valueOf(args[0]);
        switch (serviceImpl) {
            case StripedExecutorServiceMonitorNotificationServiceImpl: {
                int totalNumberOfServiceThreads = args.length == 2 ? NumberUtils.toInt((String)args[1], (int)10) : 10;
                serviceFactory = new StripedExecutorServiceMonitorNotificationServiceFactory(totalNumberOfServiceThreads);
                break;
            }
            case DisruptorOldMonitorNotificationServiceImpl: {
                serviceFactory = new DisruptorMonitorNotificationServiceFactory(true);
                break;
            }
            case DisruptorNewMonitorNotificationServiceImpl: {
                serviceFactory = new DisruptorMonitorNotificationServiceFactory(false);
                break;
            }
            case BlockingQueueSingleWorkerMonitorNotificationServiceImpl: {
                if (args.length >= 2) {
                    logger.log(Level.INFO, "Note: in this implementation the value for the number of notification threads will be ignored and set to 1.");
                }
                boolean totalNumberOfServiceThreads = true;
                int notificationValueBufferQueueSize = args.length == 3 ? NumberUtils.toInt((String)args[2], (int)Integer.MAX_VALUE) : Integer.MAX_VALUE;
                serviceFactory = new BlockingQueueMonitorNotificationServiceFactory(1, notificationValueBufferQueueSize);
                break;
            }
            default: {
                int totalNumberOfServiceThreads = args.length >= 2 ? NumberUtils.toInt((String)args[1], (int)10) : 10;
                int notificationValueBufferQueueSize = args.length == 3 ? NumberUtils.toInt((String)args[2], (int)Integer.MAX_VALUE) : Integer.MAX_VALUE;
                serviceFactory = new BlockingQueueMonitorNotificationServiceFactory(totalNumberOfServiceThreads, notificationValueBufferQueueSize);
            }
        }
        serviceFactoryList.add(serviceFactory);
        return serviceFactory;
    }

    @Override
    public void close() {
        serviceFactoryList.forEach(MonitorNotificationServiceFactory::close);
        serviceFactoryList.clear();
    }

    public static List<String> getAllServiceImplementations() {
        return Arrays.stream(ServiceImpl.values()).map(Enum::toString).collect(Collectors.toList());
    }

    public static long getServiceCount() {
        return serviceFactoryList.stream().mapToInt(MonitorNotificationServiceFactory::getServiceCount).sum();
    }

    public static void shutdownExecutor(ExecutorService executorService) {
        logger.log(Level.FINEST, "Starting executor shutdown sequence...");
        executorService.shutdown();
        try {
            logger.log(Level.FINEST, "Waiting 2 seconds for tasks to finish...");
            if (executorService.awaitTermination(2L, TimeUnit.SECONDS)) {
                logger.log(Level.FINEST, "Executor terminated ok.");
            } else {
                logger.log(Level.FINEST, "Executor did not yet terminate. Forcing termination...");
                executorService.shutdownNow();
                executorService.awaitTermination(2L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException ex) {
            logger.log(Level.WARNING, "Interrupted whilst waiting for tasks to finish. Propagating interrupt.");
            Thread.currentThread().interrupt();
        }
        logger.log(Level.FINEST, "Executor shutdown sequence completed.");
    }

    static enum ServiceImpl {
        BlockingQueueSingleWorkerMonitorNotificationServiceImpl,
        BlockingQueueMultipleWorkerMonitorNotificationServiceImpl,
        DisruptorOldMonitorNotificationServiceImpl,
        DisruptorNewMonitorNotificationServiceImpl,
        StripedExecutorServiceMonitorNotificationServiceImpl;

        private static final ServiceImpl[] copyOfValues;

        public static boolean isRecognised(String name) {
            for (ServiceImpl value : copyOfValues) {
                if (!value.name().equals(name)) continue;
                return true;
            }
            return false;
        }

        static {
            copyOfValues = ServiceImpl.values();
        }
    }
}

