/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.monitor.disruptor;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.epics.ca.impl.monitor.MonitorNotificationService;
import org.epics.ca.impl.monitor.MonitorNotificationServiceFactory;
import org.epics.ca.impl.monitor.disruptor.DisruptorNewMonitorNotificationService;
import org.epics.ca.impl.monitor.disruptor.DisruptorOldMonitorNotificationService;

public class DisruptorMonitorNotificationServiceFactory
implements MonitorNotificationServiceFactory,
AutoCloseable {
    private static final Logger logger = Logger.getLogger(DisruptorMonitorNotificationServiceFactory.class.getName());
    private final List<MonitorNotificationService> serviceList = new ArrayList<MonitorNotificationService>();
    private final boolean oldImpl;

    public DisruptorMonitorNotificationServiceFactory(boolean oldImpl) {
        this.oldImpl = oldImpl;
        int numberOfThreadsBaseline = Thread.getAllStackTraces().keySet().size();
        logger.log(Level.FINEST, String.format("The number of baseline threads in the system is: %d", numberOfThreadsBaseline));
        if (oldImpl) {
            logger.log(Level.INFO, "A DisruptorMonitorNotificationServiceFactory is being created to work with the OLD Disruptor implementation...");
        } else {
            logger.log(Level.INFO, "A DisruptorMonitorNotificationServiceFactory is being created to work with the NEW Disruptor implementation...");
        }
    }

    @Override
    public <T> MonitorNotificationService<T> getServiceForConsumer(Consumer<? super T> consumer) {
        Validate.notNull(consumer);
        MonitorNotificationService<T> instance = this.oldImpl ? new DisruptorOldMonitorNotificationService<T>(consumer) : new DisruptorNewMonitorNotificationService<T>(consumer);
        this.serviceList.add(instance);
        instance.init();
        return instance;
    }

    @Override
    public void close() {
        logger.log(Level.FINEST, String.format("A DisruptorMonitorNotificationServiceFactory is being closed with %d service entries...", this.getServiceCount()));
        for (MonitorNotificationService service : this.serviceList) {
            service.close();
        }
        this.serviceList.clear();
    }

    @Override
    public int getServiceCount() {
        return this.serviceList.size();
    }

    @Override
    public int getQosMetricNumberOfNotificationThreadsPerConsumer() {
        return 1;
    }

    @Override
    public boolean getQosMetricIsNullPublishable() {
        return true;
    }

    @Override
    public boolean getQosMetricIsBuffered() {
        return false;
    }

    @Override
    public int getQosMetricBufferSizePerConsumer() {
        return 2;
    }
}

