/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.monitor.striped;

import eu.javaspecialists.tjsn.concurrency.stripedexecutor.StripedRunnable;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang3.Validate;

@Immutable
class StripedMonitorNotificationTask<T>
implements StripedRunnable {
    private static final Logger logger = Logger.getLogger(StripedMonitorNotificationTask.class.getName());
    private final T value;
    private final Consumer<? super T> valueConsumer;

    StripedMonitorNotificationTask(Consumer<? super T> valueConsumer, T value) {
        this.valueConsumer = (Consumer)Validate.notNull(valueConsumer);
        this.value = Validate.notNull(value);
    }

    @Override
    public void run() {
        try {
            this.valueConsumer.accept(this.value);
        }
        catch (RuntimeException ex) {
            logger.log(Level.WARNING, "Unexpected exception during transfer. Message was: '%s'", ex);
            ex.printStackTrace();
        }
    }

    @Override
    public Object getStripe() {
        return this.valueConsumer;
    }
}

