/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.util.net;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;

public class InetAddressUtil {
    private static String hostName = null;

    public static InetSocketAddress[] getBroadcastAddresses(int port) {
        Enumeration<NetworkInterface> nets;
        try {
            nets = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException se) {
            return new InetSocketAddress[]{new InetSocketAddress("255.255.255.255", port)};
        }
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>(10);
        while (nets.hasMoreElements()) {
            NetworkInterface net = nets.nextElement();
            try {
                List<InterfaceAddress> interfaceAddresses;
                if (!net.isUp() || (interfaceAddresses = net.getInterfaceAddresses()) == null) continue;
                for (InterfaceAddress addr : interfaceAddresses) {
                    InetSocketAddress isa;
                    if (addr.getBroadcast() == null || list.contains(isa = new InetSocketAddress(addr.getBroadcast(), port))) continue;
                    list.add(isa);
                }
            }
            catch (Throwable throwable) {
            }
        }
        if (list.size() == 0) {
            list.add(new InetSocketAddress(InetAddress.getLoopbackAddress(), port));
        }
        InetSocketAddress[] retVal = new InetSocketAddress[list.size()];
        list.toArray(retVal);
        return retVal;
    }

    public static InetAddress intToIPv4Address(int addr) {
        byte[] a = new byte[]{(byte)(addr >> 24 & 0xFF), (byte)(addr >> 16 & 0xFF), (byte)(addr >> 8 & 0xFF), (byte)(addr & 0xFF)};
        InetAddress res = null;
        try {
            res = InetAddress.getByAddress(a);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return res;
    }

    public static int ipv4AddressToInt(InetAddress addr) {
        if (addr instanceof Inet6Address) {
            throw new IllegalArgumentException("IPv6 address used in IPv4 context");
        }
        byte[] a = addr.getAddress();
        int res = (a[0] & 0xFF) << 24 | (a[1] & 0xFF) << 16 | (a[2] & 0xFF) << 8 | a[3] & 0xFF;
        return res;
    }

    public static InetSocketAddress[] getSocketAddressList(String list, int defaultPort) {
        return InetAddressUtil.getSocketAddressList(list, defaultPort, null);
    }

    public static InetSocketAddress[] getSocketAddressList(String list, int defaultPort, InetSocketAddress[] appendList) {
        ArrayList<InetSocketAddress> al = new ArrayList<InetSocketAddress>();
        StringTokenizer st = new StringTokenizer(list);
        while (st.hasMoreTokens()) {
            int port = defaultPort;
            String address = st.nextToken();
            int pos = address.indexOf(58);
            if (pos >= 0) {
                try {
                    port = Integer.parseInt(address.substring(pos + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                address = address.substring(0, pos);
            }
            al.add(new InetSocketAddress(address, port));
        }
        int appendSize = appendList == null ? 0 : appendList.length;
        InetSocketAddress[] isar = new InetSocketAddress[al.size() + appendSize];
        al.toArray(isar);
        if (appendSize > 0) {
            System.arraycopy(appendList, 0, isar, al.size(), appendSize);
        }
        return isar;
    }

    public static synchronized String getHostName() {
        if (hostName == null) {
            int dotPos;
            hostName = "localhost";
            try {
                InetAddress localAddress = InetAddress.getLocalHost();
                hostName = localAddress.getHostName();
            }
            catch (Throwable uhe) {
                try {
                    String envHN = System.getenv("HOSTNAME");
                    if (envHN != null) {
                        hostName = envHN;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                hostName = System.getProperty("HOSTNAME", hostName);
            }
            if (System.getProperties().contains("CA_STRIP_HOSTNAME") && (dotPos = hostName.indexOf(46)) > 0) {
                hostName = hostName.substring(0, dotPos);
            }
        }
        return hostName;
    }
}

