/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.epics.ca.impl.ContextImpl;
import org.epics.ca.impl.Header;
import org.epics.ca.impl.ResponseHandlers;
import org.epics.ca.impl.Transport;
import org.epics.ca.impl.reactor.ReactorHandler;

public class BroadcastTransport
implements ReactorHandler,
Transport {
    private static final Logger logger = Logger.getLogger(BroadcastTransport.class.getName());
    private final ContextImpl context;
    private final DatagramChannel channel;
    private final InetSocketAddress socketAddress;
    private final InetSocketAddress connectAddress;
    private final InetSocketAddress[] broadcastAddresses;
    private final ByteBuffer receiveBuffer;
    protected final ResponseHandlers.ResponseHandler responseHandler;
    private final Header header = new Header();

    public BroadcastTransport(ContextImpl context, ResponseHandlers.ResponseHandler responseHandler, DatagramChannel channel, InetSocketAddress connectAddress, InetSocketAddress[] broadcastAddresses) {
        this.context = context;
        this.responseHandler = responseHandler;
        this.channel = channel;
        this.connectAddress = connectAddress;
        this.broadcastAddresses = broadcastAddresses;
        this.socketAddress = (InetSocketAddress)channel.socket().getRemoteSocketAddress();
        this.receiveBuffer = ByteBuffer.allocate(65551);
    }

    public void close() {
        if (this.connectAddress != null) {
            logger.log(Level.FINER, "UDP connection to " + this.connectAddress + " closed.");
        }
        this.context.getReactor().unregisterAndClose(this.channel);
    }

    @Override
    public void handleEvent(SelectionKey key) {
        if (key.isValid() && key.isReadable()) {
            this.processRead();
        }
        if (key.isValid() && key.isWritable()) {
            this.processWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void processRead() {
        block10: {
            try {
                block7: while (true) {
                    this.receiveBuffer.clear();
                    fromAddress = (InetSocketAddress)this.channel.receive(this.receiveBuffer);
                    if (fromAddress == null) break block10;
                    BroadcastTransport.logger.log(Level.FINEST, "Received " + this.receiveBuffer.position() + " bytes from " + fromAddress + ".");
                    this.receiveBuffer.flip();
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        if (this.receiveBuffer.limit() - this.receiveBuffer.position() < 16) continue block7;
                        this.header.read(this.receiveBuffer);
                        pos = this.receiveBuffer.position();
                        endOfMessage = pos + this.header.payloadSize;
                        if (endOfMessage > this.receiveBuffer.limit()) {
                            BroadcastTransport.logger.log(Level.WARNING, "Malformed UDP packet/CA message - the packet does not contain complete payload.");
                            continue block7;
                        }
                        try {
                            this.responseHandler.handleResponse(fromAddress, this, this.header, this.receiveBuffer);
                        }
                        catch (Throwable th) {
                            BroadcastTransport.logger.log(Level.WARNING, String.format("'%s': unexpected exception caught while processing CA message over UDP from '%s'", new Object[]{th, fromAddress}));
                        }
                        finally {
                            this.receiveBuffer.position(endOfMessage);
                            continue;
                        }
                        break;
                    }
                    break;
                }
            }
            catch (IOException ioex) {
                BroadcastTransport.logger.log(Level.SEVERE, "Failed to process UDP packet.", ioex);
            }
            ** GOTO lbl-1000
        }
    }

    protected void processWrite() {
    }

    public void send(ByteBuffer buffer) {
        if (this.broadcastAddresses == null) {
            return;
        }
        for (int i = 0; i < this.broadcastAddresses.length; ++i) {
            try {
                buffer.flip();
                this.channel.send(buffer, this.broadcastAddresses[i]);
                continue;
            }
            catch (Throwable ioex) {
                logger.log(Level.WARNING, "Failed to sent a datagram to:" + this.broadcastAddresses[i], ioex);
            }
        }
    }

    public void send(ByteBuffer buffer, InetSocketAddress address) throws IOException {
        buffer.flip();
        this.channel.send(buffer, address);
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.socketAddress;
    }

    @Override
    public ContextImpl getContext() {
        return this.context;
    }

    @Override
    public short getMinorRevision() {
        return 13;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public ByteBuffer acquireSendBuffer(int requiredSize) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void releaseSendBuffer(boolean ignore, boolean flush) {
    }

    @Override
    public void flush() {
    }
}

