/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.epics.ca.impl.Transport;
import org.epics.ca.util.IntHashMap;

public class TransportRegistry {
    private final Map<InetSocketAddress, IntHashMap<Transport>> transports = new HashMap<InetSocketAddress, IntHashMap<Transport>>();
    private final ArrayList<Transport> allTransports = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(InetSocketAddress address, Transport transport) {
        Map<InetSocketAddress, IntHashMap<Transport>> map = this.transports;
        synchronized (map) {
            IntHashMap<Transport> priorities = this.transports.get(address);
            if (priorities == null) {
                priorities = new IntHashMap();
                this.transports.put(address, priorities);
            }
            priorities.put(transport.getPriority(), transport);
            this.allTransports.add(transport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transport get(InetSocketAddress address, int priority) {
        Map<InetSocketAddress, IntHashMap<Transport>> map = this.transports;
        synchronized (map) {
            IntHashMap<Transport> priorities = this.transports.get(address);
            if (priorities != null) {
                return priorities.get(priority);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transport[] get(InetSocketAddress address) {
        Map<InetSocketAddress, IntHashMap<Transport>> map = this.transports;
        synchronized (map) {
            IntHashMap<Transport> priorities = this.transports.get(address);
            if (priorities != null) {
                Transport[] ts = new Transport[priorities.size()];
                priorities.toArray((Transport[])ts);
                return ts;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transport remove(InetSocketAddress address, int priority) {
        Map<InetSocketAddress, IntHashMap<Transport>> map = this.transports;
        synchronized (map) {
            IntHashMap<Transport> priorities = this.transports.get(address);
            if (priorities != null) {
                Transport transport = priorities.remove(priority);
                if (priorities.size() == 0) {
                    this.transports.remove(address);
                }
                if (transport != null) {
                    this.allTransports.remove(transport);
                }
                return transport;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<InetSocketAddress, IntHashMap<Transport>> map = this.transports;
        synchronized (map) {
            this.transports.clear();
            this.allTransports.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberOfActiveTransports() {
        Map<InetSocketAddress, IntHashMap<Transport>> map = this.transports;
        synchronized (map) {
            return this.allTransports.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transport[] toArray() {
        Map<InetSocketAddress, IntHashMap<Transport>> map = this.transports;
        synchronized (map) {
            return this.allTransports.toArray(new Transport[this.transports.size()]);
        }
    }
}

