/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.monitor.disruptor;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.DataProvider;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventProcessor;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.FatalExceptionHandler;
import com.lmax.disruptor.LifecycleAware;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.SequenceReportingEventHandler;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.TimeoutHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.epics.ca.impl.monitor.disruptor.ConnectionInterruptable;

public final class MonitorBatchEventProcessor<T>
implements EventProcessor {
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ExceptionHandler<? super T> exceptionHandler = new FatalExceptionHandler();
    private final DataProvider<T> dataProvider;
    private final SequenceBarrier sequenceBarrier;
    private final EventHandler<? super T> eventHandler;
    private final Sequence sequence = new Sequence(-1L);
    private final TimeoutHandler timeoutHandler;
    private final ConnectionInterruptable channel;
    private final T disconnectedValue;
    private final Predicate<T> isDisconnectedValue;

    public MonitorBatchEventProcessor(ConnectionInterruptable channel, T disconnectedValue, Predicate<T> isDisconnectedValue, DataProvider<T> dataProvider, SequenceBarrier sequenceBarrier, EventHandler<? super T> eventHandler) {
        this.channel = channel;
        this.disconnectedValue = disconnectedValue;
        this.isDisconnectedValue = isDisconnectedValue;
        this.dataProvider = dataProvider;
        this.sequenceBarrier = sequenceBarrier;
        this.eventHandler = eventHandler;
        if (eventHandler instanceof SequenceReportingEventHandler) {
            ((SequenceReportingEventHandler)eventHandler).setSequenceCallback(this.sequence);
        }
        this.timeoutHandler = eventHandler instanceof TimeoutHandler ? (TimeoutHandler)eventHandler : null;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void halt() {
        this.running.set(false);
        this.sequenceBarrier.alert();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public void setExceptionHandler(ExceptionHandler<? super T> exceptionHandler) {
        if (null == exceptionHandler) {
            throw new NullPointerException();
        }
        this.exceptionHandler = exceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block17: {
            if (!this.running.compareAndSet(false, true)) {
                throw new IllegalStateException("Thread is already running");
            }
            this.sequenceBarrier.clearAlert();
            this.notifyStart();
            int lastConnectionLossId = this.channel.getConnectionLossId();
            Object event = null;
            long nextSequence = this.sequence.get() + 1L;
            block11: while (true) {
                while (true) {
                    block16: {
                        try {
                            long availableSequence = this.sequenceBarrier.waitFor(nextSequence);
                            while (nextSequence <= availableSequence) {
                                event = this.dataProvider.get(nextSequence);
                                if (this.isDisconnectedValue.test(event)) {
                                    lastConnectionLossId = this.channel.getConnectionLossId();
                                }
                                this.eventHandler.onEvent(event, nextSequence, nextSequence == availableSequence);
                                ++nextSequence;
                            }
                            this.sequence.set(availableSequence);
                        }
                        catch (TimeoutException e) {
                            this.notifyTimeout(this.sequence.get());
                        }
                        catch (AlertException ex) {
                            if (this.running.get()) break block16;
                            break block17;
                        }
                        catch (Throwable ex) {
                            this.exceptionHandler.handleEventException(ex, nextSequence, event);
                            this.sequence.set(nextSequence);
                            ++nextSequence;
                        }
                    }
                    try {
                        int connectionLossId = this.channel.getConnectionLossId();
                        if (lastConnectionLossId == connectionLossId) continue block11;
                        lastConnectionLossId = connectionLossId;
                        this.eventHandler.onEvent(this.disconnectedValue, -1L, true);
                        continue;
                    }
                    catch (TimeoutException e) {
                        this.notifyTimeout(-1L);
                        continue;
                    }
                    catch (AlertException ex) {
                        if (this.running.get()) continue;
                        break block17;
                    }
                    catch (Throwable ex) {
                        this.exceptionHandler.handleEventException(ex, -1L, event);
                        continue;
                    }
                    break;
                }
                break;
            }
            finally {
                this.notifyShutdown();
                this.running.set(false);
            }
        }
    }

    private void notifyTimeout(long availableSequence) {
        try {
            if (this.timeoutHandler != null) {
                this.timeoutHandler.onTimeout(availableSequence);
            }
        }
        catch (Throwable e) {
            this.exceptionHandler.handleEventException(e, availableSequence, null);
        }
    }

    private void notifyStart() {
        if (this.eventHandler instanceof LifecycleAware) {
            try {
                ((LifecycleAware)this.eventHandler).onStart();
            }
            catch (Throwable ex) {
                this.exceptionHandler.handleOnStartException(ex);
            }
        }
    }

    private void notifyShutdown() {
        if (this.eventHandler instanceof LifecycleAware) {
            try {
                ((LifecycleAware)this.eventHandler).onShutdown();
            }
            catch (Throwable ex) {
                this.exceptionHandler.handleOnShutdownException(ex);
            }
        }
    }
}

