/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.util.logging;

import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.epics.ca.util.logging.ConsoleLogFormatter;

public class ConsoleLogHandler
extends Handler {
    private final Formatter formatter;

    public ConsoleLogHandler() {
        this(new ConsoleLogFormatter());
    }

    public ConsoleLogHandler(Formatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
        System.out.flush();
    }

    @Override
    public void publish(LogRecord record) {
        if (this.isLoggable(record)) {
            System.out.print(this.formatter.format(record));
        }
    }

    public static void defaultConsoleLogging(Level logLevel) {
        LogManager.getLogManager().reset();
        Logger rootLogger = Logger.getLogger("");
        rootLogger.setLevel(logLevel);
        rootLogger.addHandler(new ConsoleLogHandler());
    }
}

