/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl;

import com.lmax.disruptor.EventFactory;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.epics.ca.AccessRights;
import org.epics.ca.Channel;
import org.epics.ca.ConnectionState;
import org.epics.ca.Constants;
import org.epics.ca.Listener;
import org.epics.ca.Monitor;
import org.epics.ca.Status;
import org.epics.ca.data.Metadata;
import org.epics.ca.impl.ContextImpl;
import org.epics.ca.impl.Messages;
import org.epics.ca.impl.ResponseRequest;
import org.epics.ca.impl.StatefullEventSource;
import org.epics.ca.impl.TCPTransport;
import org.epics.ca.impl.Transport;
import org.epics.ca.impl.TransportClient;
import org.epics.ca.impl.TypeSupports;
import org.epics.ca.impl.monitor.MonitorNotificationService;
import org.epics.ca.impl.monitor.MonitorNotificationServiceFactory;
import org.epics.ca.impl.requests.MonitorRequest;
import org.epics.ca.impl.requests.ReadNotifyRequest;
import org.epics.ca.impl.requests.WriteNotifyRequest;
import org.epics.ca.util.Holder;
import org.epics.ca.util.IntHashMap;

public class ChannelImpl<T>
implements Channel<T>,
TransportClient {
    private static final Logger logger = Logger.getLogger(ChannelImpl.class.getName());
    protected final ContextImpl context;
    protected final String name;
    protected final Class<T> channelType;
    protected final int priority;
    protected final int cid;
    protected final int INVALID_SID = -1;
    protected int sid = -1;
    protected TCPTransport transport;
    protected final Map<String, Object> properties = new HashMap<String, Object>();
    protected final AtomicReference<ConnectionState> connectionState = new AtomicReference<ConnectionState>(ConnectionState.NEVER_CONNECTED);
    protected final AtomicReference<AccessRights> accessRights = new AtomicReference<AccessRights>(AccessRights.NO_RIGHTS);
    protected final IntHashMap<ResponseRequest> responseRequests = new IntHashMap();
    protected final TypeSupports.TypeSupport<T> typeSupport;
    protected final AtomicBoolean connectIssueed = new AtomicBoolean(false);
    protected final AtomicReference<CompletableFuture<Channel<T>>> connectFuture = new AtomicReference();
    protected boolean allowCreation = false;
    protected volatile int nativeElementCount = 0;
    private final AtomicInteger connectionLossId = new AtomicInteger();
    protected final Map<ConnectionListener, BiConsumer<Channel<T>, Boolean>> connectionListeners = new HashMap<ConnectionListener, BiConsumer<Channel<T>, Boolean>>();
    protected final Map<AccessRightsListener, BiConsumer<Channel<T>, AccessRights>> accessRightsListeners = new HashMap<AccessRightsListener, BiConsumer<Channel<T>, AccessRights>>();
    protected final AtomicReference<Object> timerIdRef = new AtomicReference();
    protected final AccessRightsStatefullEventSource accessRightsEventSource = new AccessRightsStatefullEventSource();
    protected final ConnectionStateStatefullEventSource connectionStateEventSource = new ConnectionStateStatefullEventSource();

    public ChannelImpl(ContextImpl context, String name, Class<T> channelType, int priority) {
        this.context = context;
        this.name = name;
        this.channelType = channelType;
        this.priority = priority;
        TypeSupports.TypeSupport<Object> typeSupport = this.typeSupport = channelType.equals(Object.class) ? new DynamicTypeSupport() : TypeSupports.getTypeSupport(channelType);
        if (this.typeSupport == null) {
            throw new RuntimeException("unsupported channel data type " + channelType);
        }
        this.cid = context.generateCID();
        context.registerChannel(this);
    }

    private TypeSupports.TypeSupport<?> getTypeSupport(Class<?> metaTypeClass, Class<?> typeClass) {
        TypeSupports.TypeSupport<?> metaTypeSupport = TypeSupports.getTypeSupport(metaTypeClass, typeClass);
        if (metaTypeSupport == null) {
            if (this.typeSupport instanceof DynamicTypeSupport) {
                Class nativeType = (Class)this.properties.get(Constants.ChannelProperties.nativeType.name());
                metaTypeSupport = TypeSupports.getTypeSupport(metaTypeClass, nativeType);
            }
            if (metaTypeSupport == null) {
                throw new RuntimeException("unsupported channel metadata type " + metaTypeClass + "<" + typeClass + ">");
            }
        }
        return metaTypeSupport;
    }

    @Override
    public void close() {
        if (this.connectionState.getAndSet(ConnectionState.CLOSED) == ConnectionState.CLOSED) {
            return;
        }
        this.context.getChannelSearchManager().unregisterChannel(this);
        this.disconnectPendingIO(true);
        if (this.transport != null) {
            try {
                Messages.clearChannelMessage(this.transport, this.cid, this.sid);
                this.transport.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.transport.release(this);
            this.transport = null;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ConnectionState getConnectionState() {
        return this.connectionState.get();
    }

    public int getConnectionLossId() {
        return this.connectionLossId.get();
    }

    @Override
    public AccessRights getAccessRights() {
        return this.accessRights.get();
    }

    public int getCID() {
        return this.cid;
    }

    public int getSID() {
        return this.sid;
    }

    @Override
    public CompletableFuture<Channel<T>> connectAsync() {
        if (!this.connectIssueed.getAndSet(true)) {
            this.initiateSearch();
            CompletableFuture<Channel<T>> future = new CompletableFuture<Channel<T>>();
            this.connectFuture.set(future);
            return future;
        }
        throw new IllegalStateException("Connect already issued on this channel instance.");
    }

    @Override
    public Channel<T> connect() {
        try {
            return this.connectAsync().get();
        }
        catch (Throwable th) {
            throw new RuntimeException("Failed to connect.", th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Listener addConnectionListener(BiConsumer<Channel<T>, Boolean> handler) {
        ConnectionListener cl = new ConnectionListener();
        Map<ConnectionListener, BiConsumer<Channel<T>, Boolean>> map = this.connectionListeners;
        synchronized (map) {
            this.connectionListeners.put(cl, handler);
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Listener addAccessRightListener(BiConsumer<Channel<T>, AccessRights> handler) {
        AccessRightsListener arl = new AccessRightsListener();
        Map<AccessRightsListener, BiConsumer<Channel<T>, AccessRights>> map = this.accessRightsListeners;
        synchronized (map) {
            this.accessRightsListeners.put(arl, handler);
        }
        return arl;
    }

    @Override
    public T get() {
        try {
            return this.getAsync().get();
        }
        catch (Throwable th) {
            throw new RuntimeException("Failed to do get.", th);
        }
    }

    @Override
    public void put(T value) {
        try {
            CompletableFuture<Status> call = this.putAsync(value);
            Status status = call.get();
            if (!status.isSuccessful()) {
                throw new RuntimeException(status.getMessage());
            }
        }
        catch (Throwable th) {
            throw new RuntimeException("Failed to do put.", th);
        }
    }

    @Override
    public void putNoWait(T value) {
        TCPTransport t = this.connectionRequiredCheck();
        AccessRights currentRights = this.getAccessRights();
        if (currentRights != AccessRights.WRITE && currentRights != AccessRights.READ_WRITE) {
            throw new IllegalStateException("No write rights.");
        }
        int count = this.typeSupport.getForcedElementCount();
        if (count == 0) {
            count = Array.getLength(value);
        }
        Messages.writeMessage(t, this.sid, this.cid, this.typeSupport, value, count);
        this.transport.flush();
    }

    @Override
    public CompletableFuture<T> getAsync() {
        TCPTransport t = this.connectionRequiredCheck();
        AccessRights currentRights = this.getAccessRights();
        if (currentRights != AccessRights.READ && currentRights != AccessRights.READ_WRITE) {
            throw new IllegalStateException("No read rights.");
        }
        return new ReadNotifyRequest<T>(this, t, this.sid, this.typeSupport);
    }

    @Override
    public CompletableFuture<Status> putAsync(T value) {
        TCPTransport t = this.connectionRequiredCheck();
        AccessRights currentRights = this.getAccessRights();
        if (currentRights != AccessRights.WRITE && currentRights != AccessRights.READ_WRITE) {
            throw new IllegalStateException("No write rights.");
        }
        int count = this.typeSupport.getForcedElementCount();
        if (count == 0) {
            count = Array.getLength(value);
        }
        return new WriteNotifyRequest<T>(this, t, this.sid, this.typeSupport, value, count);
    }

    @Override
    public <MT extends Metadata<T>> MT get(Class<? extends Metadata> clazz) {
        try {
            return (MT)((Metadata)this.getAsync(clazz).get());
        }
        catch (Throwable th) {
            throw new RuntimeException("Failed to do get.", th);
        }
    }

    @Override
    public <MT extends Metadata<T>> CompletableFuture<MT> getAsync(Class<? extends Metadata> clazz) {
        TCPTransport t = this.connectionRequiredCheck();
        TypeSupports.TypeSupport<? extends Metadata> metaTypeSupport = this.getTypeSupport(clazz, this.channelType);
        AccessRights currentRights = this.getAccessRights();
        if (currentRights != AccessRights.READ && currentRights != AccessRights.READ_WRITE) {
            throw new IllegalStateException("No read rights.");
        }
        return new ReadNotifyRequest<Metadata>(this, t, this.sid, metaTypeSupport);
    }

    @Override
    public Monitor<T> addValueMonitor(Consumer<? super T> handler, int mask) {
        if (mask == 0) {
            throw new IllegalArgumentException("null mask");
        }
        TCPTransport transport = this.connectionRequiredCheck();
        MonitorNotificationServiceFactory serviceFactory = this.context.getMonitorNotificationServiceFactory();
        MonitorNotificationService<? super T> notifier = serviceFactory.getServiceForConsumer(handler);
        return new MonitorRequest<T>(this, transport, this.typeSupport, mask, notifier, handler);
    }

    @Override
    public <MT extends Metadata<T>> Monitor<MT> addMonitor(Class<? extends Metadata> clazz, Consumer<MT> handler, int mask) {
        if (mask == 0) {
            throw new IllegalArgumentException("null mask");
        }
        TCPTransport transport = this.connectionRequiredCheck();
        TypeSupports.TypeSupport<? extends Metadata> metaTypeSupport = this.getTypeSupport(clazz, this.channelType);
        MonitorNotificationServiceFactory serviceFactory = this.context.getMonitorNotificationServiceFactory();
        MonitorNotificationService<MT> notifier = serviceFactory.getServiceForConsumer(handler);
        return new MonitorRequest<Metadata>(this, transport, metaTypeSupport, mask, notifier, handler);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setTimerId(Object timerId) {
        this.timerIdRef.set(timerId);
    }

    public Object getTimerId() {
        return this.timerIdRef.get();
    }

    public synchronized void initiateSearch() {
        this.allowCreation = true;
        this.context.getChannelSearchManager().registerChannel(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createChannel(TCPTransport transport, int sid, short typeCode, int elementCount) {
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            if (!this.allowCreation) {
                return;
            }
            this.allowCreation = false;
            if (this.transport != null && this.transport != transport) {
                this.disconnectPendingIO(false);
                this.transport.release(this);
            } else if (this.transport == transport) {
                return;
            }
            this.transport = transport;
            if (transport.getMinorRevision() < 4) {
                this.sid = sid;
                this.nativeElementCount = elementCount;
                this.properties.put(Constants.ChannelProperties.nativeTypeCode.name(), typeCode);
                this.properties.put(Constants.ChannelProperties.nativeElementCount.name(), elementCount);
            }
            this.properties.put(Constants.ChannelProperties.remoteAddress.name(), transport.getRemoteAddress());
        }
        try {
            Messages.createChannelMessage(transport, this.name, this.cid);
            transport.flush();
        }
        catch (Throwable th) {
            this.createChannelFailed();
        }
    }

    public void setAccessRights(int rightsCode) {
        this.setAccessRights(AccessRights.values()[rightsCode]);
    }

    public void setAccessRights(AccessRights rights) {
        AccessRights previousRights = this.accessRights.getAndSet(rights);
        if (previousRights != rights) {
            this.context.enqueueStatefullEvent(this.accessRightsEventSource);
        }
    }

    public void setConnectionState(ConnectionState state) {
        ConnectionState previousCS = this.connectionState.getAndSet(state);
        if (previousCS != state) {
            CompletableFuture cf = this.connectFuture.getAndSet(null);
            if (cf != null) {
                cf.complete(this);
            }
            this.context.enqueueStatefullEvent(this.connectionStateEventSource);
        }
    }

    protected TCPTransport connectionRequiredCheck() {
        TCPTransport t = this.getTransport();
        if (this.connectionState.get() != ConnectionState.CONNECTED || t == null) {
            throw new IllegalStateException("Channel not connected.");
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resubscribeSubscriptions(Transport transport) {
        ResponseRequest[] requests;
        IntHashMap<ResponseRequest> intHashMap = this.responseRequests;
        synchronized (intHashMap) {
            int count = this.responseRequests.size();
            if (count == 0) {
                return;
            }
            requests = new ResponseRequest[count];
            requests = this.responseRequests.toArray((ResponseRequest[])requests);
        }
        for (int i = 0; i < requests.length; ++i) {
            try {
                if (!(requests[i] instanceof MonitorRequest)) continue;
                ((MonitorRequest)requests[i]).resubscribe(transport);
                continue;
            }
            catch (Throwable th) {
                logger.log(Level.WARNING, "Unexpected exception caught during resubscription notification.", th);
            }
        }
    }

    public synchronized void connectionCompleted(int sid, short typeCode, int elementCount) throws IllegalStateException {
        if (this.connectionState.get() == ConnectionState.CLOSED) {
            return;
        }
        if (this.transport.getMinorRevision() < 1) {
            this.setAccessRights(AccessRights.READ_WRITE);
        }
        if (this.transport.getMinorRevision() >= 4) {
            this.sid = sid;
            this.nativeElementCount = elementCount;
            this.properties.put(Constants.ChannelProperties.nativeTypeCode.name(), typeCode);
            this.properties.put(Constants.ChannelProperties.nativeElementCount.name(), elementCount);
        }
        if (this.typeSupport instanceof DynamicTypeSupport) {
            TypeSupports.TypeSupport<?> nativeTypeSupport = TypeSupports.getTypeSupport(typeCode, elementCount);
            if (nativeTypeSupport == null) {
                logger.log(Level.SEVERE, "Type support for typeCode=" + typeCode + ", elementCount=" + elementCount + " is not supported, switching to String/String[]");
                nativeTypeSupport = elementCount > 1 ? TypeSupports.getTypeSupport(String[].class) : TypeSupports.getTypeSupport(String.class);
            }
            ((DynamicTypeSupport)this.typeSupport).setDelegate(nativeTypeSupport);
        }
        this.properties.put(Constants.ChannelProperties.nativeType.name(), this.typeSupport.newInstance().getClass());
        this.resubscribeSubscriptions(this.transport);
        this.setConnectionState(ConnectionState.CONNECTED);
    }

    public void createChannelFailed() {
        this.initiateSearch();
    }

    public boolean generateSearchRequestMessage(Transport transport, ByteBuffer buffer) {
        return Messages.generateSearchRequestMessage(transport, buffer, this.name, this.cid);
    }

    public synchronized TCPTransport getTransport() {
        return this.transport;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getNativeElementCount() {
        return this.nativeElementCount;
    }

    @Override
    public void transportClosed() {
        this.disconnect(true);
    }

    public synchronized void disconnect(boolean reconnect) {
        if (this.connectionState.get() != ConnectionState.CONNECTED && this.transport == null) {
            return;
        }
        this.setConnectionState(ConnectionState.DISCONNECTED);
        this.connectionLossId.incrementAndGet();
        this.disconnectPendingIO(false);
        if (this.transport != null) {
            this.transport.release(this);
            this.transport = null;
        }
        if (reconnect) {
            this.initiateSearch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectPendingIO(boolean destroy) {
        ResponseRequest[] requests;
        Status status = destroy ? Status.CHANDESTROY : Status.DISCONN;
        IntHashMap<ResponseRequest> intHashMap = this.responseRequests;
        synchronized (intHashMap) {
            requests = new ResponseRequest[this.responseRequests.size()];
            requests = this.responseRequests.toArray((ResponseRequest[])requests);
        }
        for (int i = 0; i < requests.length; ++i) {
            try {
                requests[i].exception(status.getStatusCode(), null);
                continue;
            }
            catch (Throwable th) {
                logger.log(Level.WARNING, "Unexpected exception caught during disconnect/destroy notification.", th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResponseRequest(ResponseRequest responseRequest) {
        IntHashMap<ResponseRequest> intHashMap = this.responseRequests;
        synchronized (intHashMap) {
            this.responseRequests.put(responseRequest.getIOID(), responseRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterResponseRequest(ResponseRequest responseRequest) {
        IntHashMap<ResponseRequest> intHashMap = this.responseRequests;
        synchronized (intHashMap) {
            this.responseRequests.remove(responseRequest.getIOID());
        }
    }

    public TypeSupports.TypeSupport<T> getTypeSupport() {
        return this.typeSupport;
    }

    class ConnectionStateStatefullEventSource
    extends StatefullEventSource {
        ConnectionStateStatefullEventSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch() {
            BiConsumer[] listeners;
            boolean connected = ChannelImpl.this.getConnectionState() == ConnectionState.CONNECTED;
            Map map = ChannelImpl.this.connectionListeners;
            synchronized (map) {
                listeners = new BiConsumer[ChannelImpl.this.connectionListeners.size()];
                ChannelImpl.this.connectionListeners.values().toArray(listeners);
            }
            for (int i = 0; i < listeners.length; ++i) {
                try {
                    listeners[i].accept(ChannelImpl.this, connected);
                    continue;
                }
                catch (Throwable th) {
                    logger.log(Level.WARNING, "Unexpected exception caught when dispatching connection listener event.", th);
                }
            }
        }
    }

    class AccessRightsStatefullEventSource
    extends StatefullEventSource {
        AccessRightsStatefullEventSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch() {
            BiConsumer[] listeners;
            AccessRights acr = ChannelImpl.this.getAccessRights();
            Map map = ChannelImpl.this.accessRightsListeners;
            synchronized (map) {
                listeners = new BiConsumer[ChannelImpl.this.accessRightsListeners.size()];
                ChannelImpl.this.accessRightsListeners.values().toArray(listeners);
            }
            for (int i = 0; i < listeners.length; ++i) {
                try {
                    listeners[i].accept(ChannelImpl.this, acr);
                    continue;
                }
                catch (Throwable th) {
                    logger.log(Level.WARNING, "Unexpected exception caught when dispatching access rights listener event.", th);
                }
            }
        }
    }

    static class HolderEventFactory<TT>
    implements EventFactory<Holder<TT>> {
        private final TypeSupports.TypeSupport<TT> typeSupport;

        public HolderEventFactory(TypeSupports.TypeSupport<TT> typeSupport) {
            this.typeSupport = typeSupport;
        }

        @Override
        public Holder<TT> newInstance() {
            return new Holder(this.typeSupport.newInstance());
        }
    }

    class AccessRightsListener
    implements Listener {
        AccessRightsListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Map map = ChannelImpl.this.accessRightsListeners;
            synchronized (map) {
                ChannelImpl.this.accessRightsListeners.remove(this);
            }
        }
    }

    class ConnectionListener
    implements Listener {
        ConnectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Map map = ChannelImpl.this.connectionListeners;
            synchronized (map) {
                ChannelImpl.this.connectionListeners.remove(this);
            }
        }
    }

    private class DynamicTypeSupport
    implements TypeSupports.TypeSupport<T> {
        private AtomicReference<TypeSupports.TypeSupport> delegate = new AtomicReference();

        private DynamicTypeSupport() {
        }

        public void setDelegate(TypeSupports.TypeSupport typeSupport) {
            this.delegate.set(typeSupport);
        }

        @Override
        public T newInstance() {
            return this.delegate.get().newInstance();
        }

        @Override
        public int getDataType() {
            return this.delegate.get().getDataType();
        }

        @Override
        public T deserialize(ByteBuffer buffer, T object, int count) {
            return this.delegate.get().deserialize(buffer, object, count);
        }

        @Override
        public int getForcedElementCount() {
            return this.delegate.get().getForcedElementCount();
        }

        @Override
        public void serialize(ByteBuffer buffer, T object, int count) {
            this.delegate.get().serialize(buffer, object, count);
        }

        @Override
        public int serializeSize(T object, int count) {
            return this.delegate.get().serializeSize(object, count);
        }
    }
}

