/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.epics.ca.Channel;
import org.epics.ca.Constants;
import org.epics.ca.Context;
import org.epics.ca.Version;
import org.epics.ca.impl.BeaconHandler;
import org.epics.ca.impl.BroadcastTransport;
import org.epics.ca.impl.ChannelImpl;
import org.epics.ca.impl.Messages;
import org.epics.ca.impl.ResponseHandlers;
import org.epics.ca.impl.ResponseRequest;
import org.epics.ca.impl.StatefullEventSource;
import org.epics.ca.impl.TCPTransport;
import org.epics.ca.impl.TransportClient;
import org.epics.ca.impl.TransportRegistry;
import org.epics.ca.impl.TypeSupports;
import org.epics.ca.impl.monitor.MonitorNotificationServiceFactory;
import org.epics.ca.impl.monitor.MonitorNotificationServiceFactoryCreator;
import org.epics.ca.impl.reactor.Reactor;
import org.epics.ca.impl.reactor.ReactorHandler;
import org.epics.ca.impl.reactor.lf.LeaderFollowersHandler;
import org.epics.ca.impl.reactor.lf.LeaderFollowersThreadPool;
import org.epics.ca.impl.repeater.CARepeater;
import org.epics.ca.impl.search.ChannelSearchManager;
import org.epics.ca.util.IntHashMap;
import org.epics.ca.util.logging.ConsoleLogHandler;
import org.epics.ca.util.net.InetAddressUtil;
import org.epics.ca.util.sync.NamedLockPattern;

public class ContextImpl
implements AutoCloseable,
Constants {
    private static final Logger logger;
    protected int debugLevel = 0;
    protected String addressList = "";
    protected boolean autoAddressList = true;
    protected float connectionTimeout = 30.0f;
    protected float beaconPeriod = 15.0f;
    protected int repeaterPort = 5065;
    protected int serverPort = 5064;
    protected int maxArrayBytes = 0;
    protected String monitorNotifierConfigImpl = MonitorNotificationServiceFactoryCreator.DEFAULT_IMPL;
    protected final ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();
    protected final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final MonitorNotificationServiceFactory monitorNotificationServiceFactory;
    protected volatile ScheduledFuture<?> repeaterRegistrationFuture;
    protected final Reactor reactor;
    protected final LeaderFollowersThreadPool leaderFollowersThreadPool;
    private static final int LOCK_TIMEOUT = 20000;
    private final NamedLockPattern namedLocker = new NamedLockPattern();
    private final TransportRegistry transportRegistry = new TransportRegistry();
    private final ChannelSearchManager channelSearchManager;
    private final AtomicReference<BroadcastTransport> broadcastTransport = new AtomicReference();
    private int lastCID = 0;
    protected final IntHashMap<ChannelImpl<?>> channelsByCID = new IntHashMap();
    private int lastIOID = 0;
    protected final IntHashMap<ResponseRequest> responseRequests = new IntHashMap();
    private final String hostName;
    private final String userName;
    private final AtomicBoolean closed = new AtomicBoolean();
    protected final Map<InetSocketAddress, BeaconHandler> beaconHandlers = new HashMap<InetSocketAddress, BeaconHandler>();

    public ContextImpl() {
        this(System.getProperties());
    }

    public ContextImpl(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("null properties");
        }
        this.initializeLogger(properties);
        this.loadConfig(properties);
        this.hostName = InetAddressUtil.getHostName();
        this.userName = System.getProperty("user.name", "nobody");
        try {
            this.reactor = new Reactor();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialize reactor.", e);
        }
        this.leaderFollowersThreadPool = new LeaderFollowersThreadPool();
        this.leaderFollowersThreadPool.promoteLeader(() -> this.reactor.process());
        this.broadcastTransport.set(this.initializeUDPTransport());
        InetSocketAddress repeaterLocalAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), this.repeaterPort);
        this.repeaterRegistrationFuture = this.timer.scheduleWithFixedDelay(new RepeaterRegistrationTask(repeaterLocalAddress), 0L, 60L, TimeUnit.SECONDS);
        try {
            CARepeater.startRepeater(this.repeaterPort);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.channelSearchManager = new ChannelSearchManager(this.broadcastTransport.get());
        this.monitorNotificationServiceFactory = MonitorNotificationServiceFactoryCreator.create(this.monitorNotifierConfigImpl);
    }

    protected MonitorNotificationServiceFactory getMonitorNotificationServiceFactory() {
        return this.monitorNotificationServiceFactory;
    }

    protected String readStringProperty(Properties properties, String key, String defaultValue) {
        String sValue = properties.getProperty(key, System.getenv(key));
        return sValue != null ? sValue : defaultValue;
    }

    protected boolean readBooleanProperty(Properties properties, String key, boolean defaultValue) {
        String sValue = properties.getProperty(key, System.getenv(key));
        if (sValue != null) {
            if (sValue.equalsIgnoreCase("YES")) {
                return true;
            }
            if (sValue.equalsIgnoreCase("NO")) {
                return false;
            }
            logger.log(Level.CONFIG, "Failed to parse boolean value for property " + key + ": \"" + sValue + "\", \"YES\" or \"NO\" expected.");
            return defaultValue;
        }
        return defaultValue;
    }

    protected float readFloatProperty(Properties properties, String key, float defaultValue) {
        String sValue = properties.getProperty(key, System.getenv(key));
        if (sValue != null) {
            try {
                return Float.parseFloat(sValue);
            }
            catch (Throwable th) {
                logger.log(Level.CONFIG, "Failed to parse float value for property " + key + ": \"" + sValue + "\".");
            }
        }
        return defaultValue;
    }

    protected int readIntegerProperty(Properties properties, String key, int defaultValue) {
        String sValue = properties.getProperty(key, System.getenv(key));
        if (sValue != null) {
            try {
                return Integer.parseInt(sValue);
            }
            catch (Throwable th) {
                logger.log(Level.CONFIG, "Failed to parse integer value for property " + key + ": \"" + sValue + "\".");
            }
        }
        return defaultValue;
    }

    protected void loadConfig(Properties properties) {
        logger.log(Level.CONFIG, "Java CA v" + Version.getVersionString());
        this.addressList = this.readStringProperty(properties, Context.Configuration.EPICS_CA_ADDR_LIST.toString(), this.addressList);
        logger.log(Level.CONFIG, Context.Configuration.EPICS_CA_ADDR_LIST.toString() + ": " + this.addressList);
        this.autoAddressList = this.readBooleanProperty(properties, Context.Configuration.EPICS_CA_AUTO_ADDR_LIST.toString(), this.autoAddressList);
        logger.log(Level.CONFIG, Context.Configuration.EPICS_CA_AUTO_ADDR_LIST.toString() + ": " + this.autoAddressList);
        this.connectionTimeout = this.readFloatProperty(properties, Context.Configuration.EPICS_CA_CONN_TMO.toString(), this.connectionTimeout);
        this.connectionTimeout = Math.max(0.1f, this.connectionTimeout);
        logger.log(Level.CONFIG, Context.Configuration.EPICS_CA_CONN_TMO.toString() + ": " + this.connectionTimeout);
        this.beaconPeriod = this.readFloatProperty(properties, Context.Configuration.EPICS_CA_BEACON_PERIOD.toString(), this.beaconPeriod);
        this.beaconPeriod = Math.max(0.1f, this.beaconPeriod);
        logger.log(Level.CONFIG, Context.Configuration.EPICS_CA_BEACON_PERIOD.toString() + ": " + this.beaconPeriod);
        this.repeaterPort = this.readIntegerProperty(properties, Context.Configuration.EPICS_CA_REPEATER_PORT.toString(), this.repeaterPort);
        logger.log(Level.CONFIG, Context.Configuration.EPICS_CA_REPEATER_PORT.toString() + ": " + this.repeaterPort);
        this.serverPort = this.readIntegerProperty(properties, Context.Configuration.EPICS_CA_SERVER_PORT.toString(), this.serverPort);
        logger.log(Level.CONFIG, Context.Configuration.EPICS_CA_SERVER_PORT.toString() + ": " + this.serverPort);
        this.maxArrayBytes = this.readIntegerProperty(properties, Context.Configuration.EPICS_CA_MAX_ARRAY_BYTES.toString(), this.maxArrayBytes);
        if (this.maxArrayBytes > 0) {
            this.maxArrayBytes = Math.max(1024, this.maxArrayBytes);
        }
        logger.log(Level.CONFIG, Context.Configuration.EPICS_CA_MAX_ARRAY_BYTES.toString() + ": " + (this.maxArrayBytes > 0 ? Integer.valueOf(this.maxArrayBytes) : "(undefined)"));
        this.monitorNotifierConfigImpl = this.readStringProperty(properties, "CA_MONITOR_NOTIFIER_IMPL", CA_MONITOR_NOTIFIER_DEFAULT_IMPL);
        logger.log(Level.CONFIG, "CA_MONITOR_NOTIFIER_IMPL: " + this.monitorNotifierConfigImpl);
    }

    protected void initializeLogger(Properties properties) {
        this.debugLevel = this.readIntegerProperty(properties, "CA_DEBUG", this.debugLevel);
        if (this.debugLevel > 0) {
            logger.setLevel(Level.ALL);
            boolean found = false;
            block0: for (Logger inspectedLogger = logger; inspectedLogger != null; inspectedLogger = inspectedLogger.getParent()) {
                for (Handler handler : inspectedLogger.getHandlers()) {
                    if (!(handler instanceof ConsoleLogHandler)) continue;
                    found = true;
                    continue block0;
                }
            }
            if (!found) {
                logger.addHandler(new ConsoleLogHandler());
            }
        }
    }

    protected BroadcastTransport initializeUDPTransport() {
        InetSocketAddress[] broadcastAddressList = null;
        if (this.addressList != null && this.addressList.length() > 0) {
            InetSocketAddress[] list;
            InetSocketAddress[] appendList = null;
            if (this.autoAddressList) {
                appendList = InetAddressUtil.getBroadcastAddresses(this.serverPort);
            }
            if ((list = InetAddressUtil.getSocketAddressList(this.addressList, this.serverPort, appendList)) != null && list.length > 0) {
                broadcastAddressList = list;
            }
        } else if (!this.autoAddressList) {
            logger.log(Level.WARNING, "Empty broadcast search address list, all connects will fail.");
        } else {
            broadcastAddressList = InetAddressUtil.getBroadcastAddresses(this.serverPort);
        }
        if (logger.isLoggable(Level.CONFIG) && broadcastAddressList != null) {
            for (int i = 0; i < broadcastAddressList.length; ++i) {
                logger.log(Level.CONFIG, "Broadcast address #" + i + ": " + broadcastAddressList[i] + '.');
            }
        }
        InetSocketAddress connectAddress = new InetSocketAddress(0);
        logger.log(Level.FINER, "Creating datagram socket to: " + connectAddress);
        DatagramChannel channel = null;
        try {
            channel = DatagramChannel.open();
            channel.configureBlocking(false);
            channel.socket().setBroadcast(true);
            channel.socket().setReuseAddress(true);
            channel.socket().bind(new InetSocketAddress(0));
            BroadcastTransport transport = new BroadcastTransport(this, ResponseHandlers::handleResponse, channel, connectAddress, broadcastAddressList);
            LeaderFollowersHandler handler = new LeaderFollowersHandler(this.reactor, transport, this.leaderFollowersThreadPool);
            this.reactor.register(channel, 1, handler);
            return transport;
        }
        catch (Throwable th) {
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new RuntimeException("Failed to connect to '" + connectAddress + "'.", th);
        }
    }

    public <T> Channel<T> createChannel(String channelName, Class<T> channelType) {
        return this.createChannel(channelName, channelType, 0);
    }

    public <T> Channel<T> createChannel(String channelName, Class<T> channelType, int priority) {
        if (this.closed.get()) {
            throw new RuntimeException("context closed");
        }
        if (channelName == null || channelName.length() == 0) {
            throw new IllegalArgumentException("null or empty channel name");
        }
        if (channelName.length() > Math.min(1008, 500)) {
            throw new IllegalArgumentException("name too long");
        }
        if (channelType == null) {
            throw new IllegalArgumentException("null channel type");
        }
        if (!TypeSupports.isNativeType(channelType) && !channelType.equals(Object.class)) {
            throw new IllegalArgumentException("invalid channel native type");
        }
        if (priority < 0 || priority > 99) {
            throw new IllegalArgumentException("priority out of bounds");
        }
        return new ChannelImpl<T>(this, channelName, channelType, priority);
    }

    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.channelSearchManager.cancel();
        this.broadcastTransport.get().close();
        this.destroyAllChannels();
        this.reactor.shutdown();
        this.leaderFollowersThreadPool.shutdown();
        this.timer.shutdown();
        this.monitorNotificationServiceFactory.close();
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.executorService.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyAllChannels() {
        ChannelImpl[] channels;
        IntHashMap<ChannelImpl<?>> intHashMap = this.channelsByCID;
        synchronized (intHashMap) {
            channels = new ChannelImpl[this.channelsByCID.size()];
            this.channelsByCID.toArray(channels);
            this.channelsByCID.clear();
        }
        for (int i = 0; i < channels.length; ++i) {
            try {
                if (channels[i] == null) continue;
                channels[i].close();
                continue;
            }
            catch (Throwable th) {
                logger.log(Level.SEVERE, "Unexpected exception caught while closing a channel", th);
            }
        }
    }

    public Reactor getReactor() {
        return this.reactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int generateCID() {
        IntHashMap<ChannelImpl<?>> intHashMap = this.channelsByCID;
        synchronized (intHashMap) {
            while (this.channelsByCID.containsKey(++this.lastCID)) {
            }
            this.channelsByCID.put(this.lastCID, null);
            return this.lastCID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerChannel(ChannelImpl<?> channel) {
        IntHashMap<ChannelImpl<?>> intHashMap = this.channelsByCID;
        synchronized (intHashMap) {
            this.channelsByCID.put(channel.getCID(), channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterChannel(ChannelImpl<?> channel) {
        IntHashMap<ChannelImpl<?>> intHashMap = this.channelsByCID;
        synchronized (intHashMap) {
            this.channelsByCID.remove(channel.getCID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseRequest getResponseRequest(int ioid) {
        IntHashMap<ResponseRequest> intHashMap = this.responseRequests;
        synchronized (intHashMap) {
            return this.responseRequests.get(ioid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerResponseRequest(ResponseRequest request) {
        IntHashMap<ResponseRequest> intHashMap = this.responseRequests;
        synchronized (intHashMap) {
            int ioid = this.generateIOID();
            this.responseRequests.put(ioid, request);
            return ioid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseRequest unregisterResponseRequest(ResponseRequest request) {
        IntHashMap<ResponseRequest> intHashMap = this.responseRequests;
        synchronized (intHashMap) {
            return this.responseRequests.remove(request.getIOID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int generateIOID() {
        IntHashMap<ResponseRequest> intHashMap = this.responseRequests;
        synchronized (intHashMap) {
            while (this.responseRequests.containsKey(++this.lastIOID)) {
            }
            this.responseRequests.put(this.lastIOID, null);
            return this.lastIOID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelImpl<?> getChannel(int channelID) {
        IntHashMap<ChannelImpl<?>> intHashMap = this.channelsByCID;
        synchronized (intHashMap) {
            return this.channelsByCID.get(channelID);
        }
    }

    public ChannelSearchManager getChannelSearchManager() {
        return this.channelSearchManager;
    }

    public BroadcastTransport getBroadcastTransport() {
        return this.broadcastTransport.get();
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public float getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getMaxArrayBytes() {
        return this.maxArrayBytes;
    }

    public TransportRegistry getTransportRegistry() {
        return this.transportRegistry;
    }

    public LeaderFollowersThreadPool getLeaderFollowersThreadPool() {
        return this.leaderFollowersThreadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchResponse(int cid, int sid, short type, int count, short minorRevision, InetSocketAddress serverAddress) {
        ChannelImpl<?> channel = this.getChannel(cid);
        if (channel == null) {
            return;
        }
        logger.log(Level.FINER, "Search response for channel " + channel.getName() + " received.");
        ChannelImpl<?> channelImpl = channel;
        synchronized (channelImpl) {
            TCPTransport transport = channel.getTransport();
            if (transport != null && !transport.getRemoteAddress().equals(serverAddress)) {
                logger.log(Level.INFO, "More than one PVs with name '" + channel.getName() + "' detected, additional response from: " + serverAddress);
                return;
            }
            this.channelSearchManager.searchResponse(channel);
            transport = this.getTransport(channel, serverAddress, minorRevision, channel.getPriority());
            if (transport == null) {
                channel.createChannelFailed();
                return;
            }
            channel.createChannel(transport, sid, type, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCPTransport getTransport(TransportClient client, InetSocketAddress address, short minorRevision, int priority) {
        boolean lockAcquired;
        AbstractInterruptibleChannel socket = null;
        TCPTransport transport = (TCPTransport)this.transportRegistry.get(address, priority);
        if (transport != null) {
            logger.log(Level.FINER, "Reusing existant connection to CA server: " + address);
            if (transport.acquire(client)) {
                return transport;
            }
        }
        if (lockAcquired = this.namedLocker.acquireSynchronizationObject(address, 20000L)) {
            try {
                transport = (TCPTransport)this.transportRegistry.get(address, priority);
                if (transport != null) {
                    logger.log(Level.FINER, "Reusing existant connection to CA server: " + address);
                    if (transport.acquire(client)) {
                        TCPTransport tCPTransport = transport;
                        return tCPTransport;
                    }
                }
                logger.log(Level.FINER, "Connecting to CA server: " + address);
                socket = this.tryConnect(address, 3);
                ((AbstractSelectableChannel)socket).configureBlocking(false);
                ((SocketChannel)socket).socket().setTcpNoDelay(true);
                ((SocketChannel)socket).socket().setKeepAlive(true);
                ReactorHandler handler = transport = new TCPTransport(this, client, ResponseHandlers::handleResponse, (SocketChannel)socket, minorRevision, priority);
                if (this.leaderFollowersThreadPool != null) {
                    handler = new LeaderFollowersHandler(this.reactor, handler, this.leaderFollowersThreadPool);
                }
                this.reactor.register((SelectableChannel)socket, 1, handler);
                Messages.versionMessage(transport, (short)priority, 0, false);
                Messages.userNameMessage(transport, this.userName);
                Messages.hostNameMessage(transport, this.hostName);
                transport.flush();
                logger.log(Level.FINER, "Connected to CA server: " + address);
                TCPTransport tCPTransport = transport;
                return tCPTransport;
            }
            catch (Throwable th) {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                logger.log(Level.WARNING, th, () -> "Failed to connect to '" + address + "'.");
                TCPTransport tCPTransport = null;
                return tCPTransport;
            }
            finally {
                this.namedLocker.releaseSynchronizationObject(address);
            }
        }
        logger.severe(() -> "Failed to obtain synchronization lock for '" + address + "', possible deadlock.");
        return null;
    }

    private SocketChannel tryConnect(InetSocketAddress address, int tries) throws IOException {
        IOException lastException = null;
        for (int tryCount = 0; tryCount < tries; ++tryCount) {
            if (tryCount > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            logger.log(Level.FINEST, "Opening socket to CA server " + address + ", attempt " + (tryCount + 1) + ".");
            try {
                return SocketChannel.open(address);
            }
            catch (IOException ioe) {
                lastException = ioe;
                continue;
            }
        }
        throw lastException;
    }

    public void repeaterConfirm(InetSocketAddress responseFrom) {
        logger.log(Level.FINE, "Repeater registration confirmed from: " + responseFrom);
        ScheduledFuture<?> sf = this.repeaterRegistrationFuture;
        if (sf != null) {
            sf.cancel(false);
        }
    }

    public boolean enqueueStatefullEvent(StatefullEventSource event) {
        if (event.allowEnqueue()) {
            this.executorService.execute(event);
            return true;
        }
        return false;
    }

    public void beaconAnomalyNotify() {
        if (this.channelSearchManager != null) {
            this.channelSearchManager.beaconAnomalyNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeaconHandler getBeaconHandler(InetSocketAddress responseFrom) {
        Map<InetSocketAddress, BeaconHandler> map = this.beaconHandlers;
        synchronized (map) {
            BeaconHandler handler = this.beaconHandlers.get(responseFrom);
            if (handler == null) {
                handler = new BeaconHandler(this, responseFrom);
                this.beaconHandlers.put(responseFrom, handler);
            }
            return handler;
        }
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.timer;
    }

    static {
        System.setProperty("java.net.preferIPv4Stack", "true");
        logger = Logger.getLogger(ContextImpl.class.getName());
    }

    private class RepeaterRegistrationTask
    implements Runnable {
        private final InetSocketAddress repeaterLocalAddress;
        private final ByteBuffer buffer = ByteBuffer.allocate(16);

        RepeaterRegistrationTask(InetSocketAddress repeaterLocalAddress) {
            this.repeaterLocalAddress = repeaterLocalAddress;
            Messages.generateRepeaterRegistration(this.buffer);
        }

        @Override
        public void run() {
            try {
                ContextImpl.this.getBroadcastTransport().send(this.buffer, this.repeaterLocalAddress);
            }
            catch (Throwable th) {
                logger.log(Level.FINE, th, () -> "Failed to send repeater registration message to: " + this.repeaterLocalAddress);
            }
        }
    }
}

