/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.epics.ca.Status;
import org.epics.ca.impl.BeaconHandler;
import org.epics.ca.impl.ChannelImpl;
import org.epics.ca.impl.Header;
import org.epics.ca.impl.NotifyResponseRequest;
import org.epics.ca.impl.ResponseRequest;
import org.epics.ca.impl.Transport;
import org.epics.ca.util.net.InetAddressUtil;

public class ResponseHandlers {
    private static final Logger logger = Logger.getLogger(ResponseHandlers.class.getName());
    private static final ResponseHandler[] handlers = new ResponseHandler[]{ResponseHandlers::noopResponse, ResponseHandlers::notifyResponse, ResponseHandlers::badResponse, ResponseHandlers::badResponse, ResponseHandlers::badResponse, ResponseHandlers::badResponse, ResponseHandlers::searchResponse, ResponseHandlers::badResponse, ResponseHandlers::badResponse, ResponseHandlers::badResponse, ResponseHandlers::badResponse, ResponseHandlers::exceptionResponse, ResponseHandlers::noopResponse, ResponseHandlers::beaconResponse, ResponseHandlers::badResponse, ResponseHandlers::notifyResponse, ResponseHandlers::badResponse, ResponseHandlers::repeaterConfirmResponse, ResponseHandlers::channelCreateResponse, ResponseHandlers::notifyResponse, ResponseHandlers::badResponse, ResponseHandlers::badResponse, ResponseHandlers::accessRightsResponse, ResponseHandlers::noopResponse, ResponseHandlers::badResponse, ResponseHandlers::badResponse, ResponseHandlers::badResponse, ResponseHandlers::channelDisconnectedResponse};

    public static void handleResponse(InetSocketAddress responseFrom, Transport transport, Header header, ByteBuffer payloadBuffer) {
        if (header.command < 0 || header.command >= handlers.length) {
            logger.log(Level.WARNING, "Invalid response message (command = " + header.command + ") received from: " + responseFrom);
            return;
        }
        logger.log(Level.FINEST, "Message " + header.command + " received from " + responseFrom + ", payload size " + header.payloadSize + ".");
        handlers[header.command].handleResponse(responseFrom, transport, header, payloadBuffer);
    }

    public static void noopResponse(InetSocketAddress responseFrom, Transport transport, Header header, ByteBuffer payloadBuffer) {
    }

    public static void badResponse(InetSocketAddress responseFrom, Transport transport, Header header, ByteBuffer payloadBuffer) {
        logger.log(Level.WARNING, "Unexpected response message (command = " + header.command + ") received from: " + responseFrom);
    }

    public static void beaconResponse(InetSocketAddress responseFrom, Transport transport, Header header, ByteBuffer payloadBuffer) {
        long timestamp = System.currentTimeMillis();
        int port = header.dataCount;
        if (port == 0) {
            port = (short)transport.getContext().getServerPort();
        }
        InetAddress addr = InetAddressUtil.intToIPv4Address(header.parameter2);
        responseFrom = new InetSocketAddress(addr, port);
        BeaconHandler beaconHandler = transport.getContext().getBeaconHandler(responseFrom);
        if (beaconHandler == null) {
            return;
        }
        long sequentalID = (long)header.parameter1 & 0xFFFFFFFFL;
        beaconHandler.beaconNotify(header.dataType, timestamp, sequentalID);
    }

    public static void channelDisconnectedResponse(InetSocketAddress responseFrom, Transport transport, Header header, ByteBuffer payloadBuffer) {
        ChannelImpl<?> channel = transport.getContext().getChannel(header.parameter1);
        if (channel != null) {
            channel.disconnect(true);
        }
    }

    public static void searchResponse(InetSocketAddress responseFrom, Transport transport, Header header, ByteBuffer payloadBuffer) {
        short minorVersion = 0;
        if (header.payloadSize >= 2) {
            minorVersion = payloadBuffer.getShort();
        }
        int port = header.dataType & 0xFFFF;
        if (minorVersion >= 8) {
            int INADDR_BROADCAST = -1;
            InetAddress addr = header.parameter1 != -1 ? InetAddressUtil.intToIPv4Address(header.parameter1) : responseFrom.getAddress();
            responseFrom = new InetSocketAddress(addr, port);
        } else {
            responseFrom = minorVersion >= 5 ? new InetSocketAddress(responseFrom.getAddress(), port) : new InetSocketAddress(responseFrom.getAddress(), transport.getContext().getServerPort());
        }
        if (minorVersion >= 2) {
            transport.getContext().searchResponse(header.parameter2, header.parameter1, (short)-1, 0, minorVersion, responseFrom);
        } else {
            transport.getContext().searchResponse(header.parameter2, header.parameter1, header.dataType, header.dataCount, minorVersion, responseFrom);
        }
    }

    public static void accessRightsResponse(InetSocketAddress responseFrom, Transport transport, Header header, ByteBuffer payloadBuffer) {
        ChannelImpl<?> channel = transport.getContext().getChannel(header.parameter1);
        if (channel != null) {
            channel.setAccessRights(header.parameter2);
        }
    }

    public static void channelCreateResponse(InetSocketAddress responseFrom, Transport transport, Header header, ByteBuffer payloadBuffer) {
        ChannelImpl<?> channel = transport.getContext().getChannel(header.parameter1);
        if (channel != null) {
            channel.connectionCompleted(header.parameter2, header.dataType, header.dataCount);
        }
    }

    public static void notifyResponse(InetSocketAddress responseFrom, Transport transport, Header header, ByteBuffer payloadBuffer) {
        NotifyResponseRequest nrr = (NotifyResponseRequest)transport.getContext().getResponseRequest(header.parameter2);
        if (nrr == null) {
            return;
        }
        int status = transport.getMinorRevision() < 1 ? Status.NORMAL.getValue() : header.parameter1;
        nrr.response(status, header.dataType, header.dataCount, payloadBuffer);
    }

    public static void repeaterConfirmResponse(InetSocketAddress responseFrom, Transport transport, Header header, ByteBuffer payloadBuffer) {
        transport.getContext().repeaterConfirm(responseFrom);
    }

    public static void exceptionResponse(InetSocketAddress responseFrom, Transport transport, Header header, ByteBuffer payloadBuffer) {
        int commandID;
        ByteBuffer originalHeaderBuffer = null;
        String errorMessage = null;
        int payloadStart = payloadBuffer.position();
        if (header.payloadSize > 16) {
            int errorMessageStart;
            int originalHeaderPayloadSize = payloadBuffer.getShort(payloadStart + 2) & 0xFFFF;
            int originalHeaderSize = originalHeaderPayloadSize == 65535 ? 24 : 16;
            originalHeaderBuffer = payloadBuffer.slice();
            originalHeaderBuffer.limit(originalHeaderSize);
            int errorMessageEnd = errorMessageStart = payloadStart + originalHeaderSize;
            while (payloadBuffer.get(errorMessageEnd) != 0) {
                ++errorMessageEnd;
            }
            payloadBuffer.position(errorMessageStart);
            ByteBuffer errorMessageBuffer = payloadBuffer.slice();
            errorMessageBuffer.limit(errorMessageEnd - errorMessageStart);
            errorMessage = Charset.defaultCharset().decode(errorMessageBuffer).toString();
        }
        payloadBuffer.position(payloadStart + header.payloadSize);
        int n = commandID = originalHeaderBuffer != null ? (int)originalHeaderBuffer.getShort(0) : -1;
        if (commandID < 0 || commandID >= 27) {
            logger.log(Level.WARNING, "Invalid (or unsupported) exception message command: " + commandID + ".");
            return;
        }
        if (commandID == 1 || commandID == 15 || commandID == 19) {
            int ioid = originalHeaderBuffer.getInt(12);
            ResponseRequest rr = transport.getContext().getResponseRequest(ioid);
            if (rr != null) {
                rr.exception(header.parameter2, errorMessage);
            }
        } else {
            logger.log(Level.WARNING, "Exception message reported, code: " + (Object)((Object)Status.forStatusCode(header.parameter2)) + ", message: '" + errorMessage + "'.");
        }
    }

    public static interface ResponseHandler {
        public void handleResponse(InetSocketAddress var1, Transport var2, Header var3, ByteBuffer var4);
    }
}

