/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.monitor.blockingqueue;

import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.lang3.Validate;
import org.epics.ca.impl.TypeSupports;
import org.epics.ca.impl.monitor.MonitorNotificationService;
import org.epics.ca.impl.monitor.blockingqueue.MonitorNotificationTask;

@ThreadSafe
public class BlockingQueueMonitorNotificationService<T>
implements MonitorNotificationService<T>,
Supplier<T> {
    private static final Logger logger = Logger.getLogger(BlockingQueueMonitorNotificationService.class.getName());
    private final ThreadPoolExecutor executor;
    private final Consumer<? super T> consumer;
    private final BlockingQueue<T> valueQueue;
    private T deserializedValue;

    BlockingQueueMonitorNotificationService(ThreadPoolExecutor executor, BlockingQueue<T> valueQueue, Consumer<? super T> consumer) {
        this.executor = Validate.notNull(executor);
        this.valueQueue = Validate.notNull(valueQueue);
        this.consumer = Validate.notNull(consumer);
        this.deserializedValue = null;
    }

    @Override
    public boolean publish(ByteBuffer dataBuffer, TypeSupports.TypeSupport<T> typeSupport, int dataCount) {
        this.deserializedValue = typeSupport.deserialize(dataBuffer, this.deserializedValue, dataCount);
        return this.publish(this.deserializedValue);
    }

    @Override
    public synchronized boolean publish(T value) {
        Validate.notNull(value);
        boolean overrun = false;
        if (!this.valueQueue.offer(value)) {
            logger.log(Level.FINEST, String.format("Buffer is full [size is: %d]", this.valueQueue.size()));
            overrun = true;
            Object discardedValue = this.valueQueue.remove();
            logger.log(Level.FINEST, String.format("Removing and throwing away oldest queue item, %s", discardedValue));
            this.valueQueue.add(value);
        } else {
            logger.log(Level.FINEST, String.format("Added new item to buffer [size is: %d]", this.valueQueue.size()));
            logger.log(Level.FINEST, String.format("Queueing Task for consumer '%s' on work queue '%s'. Latest value is: '%s'", this.consumer, this.executor.getQueue().hashCode(), value));
            this.executor.submit(new MonitorNotificationTask<T>(this.consumer, this));
        }
        return !overrun;
    }

    @Override
    public synchronized T get() {
        Validate.isTrue(!this.valueQueue.isEmpty(), "programming error - value notification queue was unexpectedly empty", new Object[0]);
        Object value = this.valueQueue.remove();
        logger.log(Level.FINEST, String.format("Retrieved value '%s'", value));
        return (T)value;
    }

    @Override
    public void init() {
    }

    @Override
    public void close() {
    }
}

