/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.epics.ca.impl.Transport;
import org.epics.ca.impl.TypeSupports;
import org.epics.ca.util.net.InetAddressUtil;

public final class Messages {
    public static int calculateAlignedSize(int align, int nonAlignedSize) {
        return (nonAlignedSize + align - 1) / align * align;
    }

    public static ByteBuffer startCAMessage(Transport transport, short command, int payloadSize, short dataType, int dataCount, int parameter1, int parameter2) {
        boolean useExtendedHeader;
        boolean bl = useExtendedHeader = payloadSize >= 65535 || dataCount >= 65535;
        if (useExtendedHeader && transport != null && transport.getMinorRevision() < 9) {
            throw new IllegalArgumentException("Out of bounds.");
        }
        int requiredSize = useExtendedHeader ? 24 : 16;
        ByteBuffer buffer = transport.acquireSendBuffer(requiredSize + payloadSize);
        if (!useExtendedHeader) {
            buffer.putShort(command);
            buffer.putShort((short)payloadSize);
            buffer.putShort(dataType);
            buffer.putShort((short)dataCount);
            buffer.putInt(parameter1);
            buffer.putInt(parameter2);
        } else {
            buffer.putShort(command);
            buffer.putShort((short)-1);
            buffer.putShort(dataType);
            buffer.putShort((short)0);
            buffer.putInt(parameter1);
            buffer.putInt(parameter2);
            buffer.putInt(payloadSize);
            buffer.putInt(dataCount);
        }
        return buffer;
    }

    public static final boolean generateRepeaterRegistration(ByteBuffer buffer) {
        int localAddress = InetAddressUtil.ipv4AddressToInt(InetAddress.getLoopbackAddress());
        buffer.putShort((short)24);
        buffer.putShort((short)0);
        buffer.putShort((short)0);
        buffer.putShort((short)0);
        buffer.putInt(0);
        buffer.putInt(localAddress);
        return true;
    }

    public static final boolean generateSearchRequestMessage(Transport transport, ByteBuffer buffer, String name, int cid) {
        int unalignedMessageSize = 16 + name.length() + 1;
        int alignedMessageSize = Messages.calculateAlignedSize(8, unalignedMessageSize);
        if (buffer.remaining() < alignedMessageSize) {
            return false;
        }
        buffer.putShort((short)6);
        buffer.putShort((short)(alignedMessageSize - 16));
        buffer.putShort((short)5);
        buffer.putShort(transport.getMinorRevision());
        buffer.putInt(cid);
        buffer.putInt(cid);
        buffer.put(name.getBytes());
        for (int i = alignedMessageSize - unalignedMessageSize + 1; i > 0; --i) {
            buffer.put((byte)0);
        }
        return true;
    }

    public static final void generateVersionRequestMessage(Transport transport, ByteBuffer buffer, short priority, int sequenceNumber, boolean isSequenceNumberValid) {
        short isSequenceNumberValidCode = isSequenceNumberValid ? (short)1 : 0;
        buffer.putShort((short)0);
        buffer.putShort((short)0);
        buffer.putShort(isSequenceNumberValid ? isSequenceNumberValidCode : priority);
        buffer.putShort(transport.getMinorRevision());
        buffer.putInt(sequenceNumber);
        buffer.putInt(0);
    }

    public static final void generateEchoMessage(Transport transport, ByteBuffer buffer) {
        if (transport.getMinorRevision() >= 3) {
            buffer.putShort((short)23);
            buffer.putShort((short)0);
            buffer.putShort((short)0);
            buffer.putShort((short)0);
            buffer.putInt(0);
            buffer.putInt(0);
        } else {
            buffer.putShort((short)0);
            buffer.putShort((short)0);
            buffer.putShort((short)0);
            buffer.putShort(transport.getMinorRevision());
            buffer.putInt(0);
            buffer.putInt(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void versionMessage(Transport transport, short priority, int sequenceNumber, boolean isSequenceNumberValid) {
        boolean ignore = true;
        try {
            short isSequenceNumberValidCode = isSequenceNumberValid ? (short)1 : 0;
            Messages.startCAMessage(transport, (short)0, 0, isSequenceNumberValid ? isSequenceNumberValidCode : priority, transport.getMinorRevision(), sequenceNumber, 0);
            ignore = false;
        }
        finally {
            transport.releaseSendBuffer(ignore, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hostNameMessage(Transport transport, String hostName) {
        if (transport.getMinorRevision() < 1) {
            return;
        }
        int unalignedMessageSize = 16 + hostName.length() + 1;
        int alignedMessageSize = Messages.calculateAlignedSize(8, unalignedMessageSize);
        boolean ignore = true;
        try {
            ByteBuffer buffer = Messages.startCAMessage(transport, (short)21, alignedMessageSize - 16, (short)0, 0, 0, 0);
            buffer.put(hostName.getBytes());
            for (int i = alignedMessageSize - unalignedMessageSize + 1; i > 0; --i) {
                buffer.put((byte)0);
            }
            ignore = false;
        }
        finally {
            transport.releaseSendBuffer(ignore, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void userNameMessage(Transport transport, String userName) {
        if (transport.getMinorRevision() < 1) {
            return;
        }
        int unalignedMessageSize = 16 + userName.length() + 1;
        int alignedMessageSize = Messages.calculateAlignedSize(8, unalignedMessageSize);
        boolean ignore = true;
        try {
            ByteBuffer buffer = Messages.startCAMessage(transport, (short)20, alignedMessageSize - 16, (short)0, 0, 0, 0);
            buffer.put(userName.getBytes());
            for (int i = alignedMessageSize - unalignedMessageSize + 1; i > 0; --i) {
                buffer.put((byte)0);
            }
            ignore = false;
        }
        finally {
            transport.releaseSendBuffer(ignore, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createChannelMessage(Transport transport, String channelName, int cid) {
        if (transport.getMinorRevision() < 4) {
            channelName = null;
        }
        int binaryNameLength = 0;
        if (channelName != null) {
            binaryNameLength = channelName.length() + 1;
        }
        int unalignedMessageSize = 16 + binaryNameLength;
        int alignedMessageSize = Messages.calculateAlignedSize(8, unalignedMessageSize);
        boolean ignore = true;
        try {
            ByteBuffer buffer = Messages.startCAMessage(transport, (short)18, alignedMessageSize - 16, (short)0, 0, cid, transport.getMinorRevision());
            if (binaryNameLength > 0) {
                buffer.put(channelName.getBytes());
                for (int i = alignedMessageSize - unalignedMessageSize + 1; i > 0; --i) {
                    buffer.put((byte)0);
                }
            }
            ignore = false;
        }
        finally {
            transport.releaseSendBuffer(ignore, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readNotifyMessage(Transport transport, int dataType, int dataCount, int sid, int ioid) {
        boolean ignore = true;
        try {
            Messages.startCAMessage(transport, (short)15, 0, (short)dataType, dataCount, sid, ioid);
            ignore = false;
        }
        finally {
            transport.releaseSendBuffer(ignore, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSubscriptionMessage(Transport transport, int dataType, int dataCount, int sid, int ioid, int mask) {
        boolean ignore = true;
        try {
            ByteBuffer buffer = Messages.startCAMessage(transport, (short)1, 16, (short)dataType, dataCount, sid, ioid);
            buffer.putFloat(0.0f);
            buffer.putFloat(0.0f);
            buffer.putFloat(0.0f);
            buffer.putShort((short)mask);
            buffer.putShort((short)0);
            ignore = false;
        }
        finally {
            transport.releaseSendBuffer(ignore, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelSubscriptionMessage(Transport transport, int dataType, int dataCount, int sid, int ioid) {
        boolean ignore = true;
        try {
            Messages.startCAMessage(transport, (short)2, 0, (short)dataType, dataCount, sid, ioid);
            ignore = false;
        }
        finally {
            transport.releaseSendBuffer(ignore, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearChannelMessage(Transport transport, int cid, int sid) {
        boolean ignore = true;
        try {
            Messages.startCAMessage(transport, (short)12, 0, (short)0, 0, sid, cid);
            ignore = false;
        }
        finally {
            transport.releaseSendBuffer(ignore, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void subscriptionUpdateMessage(Transport transport, int dataType, int dataCount, int sid, int ioid) {
        boolean ignore = true;
        try {
            Messages.startCAMessage(transport, (short)15, 0, (short)dataType, dataCount, sid, ioid);
            ignore = false;
        }
        finally {
            transport.releaseSendBuffer(ignore, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeMessage(Transport transport, int sid, int cid, TypeSupports.TypeSupport<T> typeSupport, T value, int count) {
        int calculatedPayloadSize = typeSupport.serializeSize(value, count);
        int alignedPayloadSize = Messages.calculateAlignedSize(8, calculatedPayloadSize);
        boolean ignore = true;
        try {
            ByteBuffer buffer = Messages.startCAMessage(transport, (short)4, alignedPayloadSize, (short)typeSupport.getDataType(), count, sid, cid);
            typeSupport.serialize(buffer, value, count);
            for (int i = alignedPayloadSize - calculatedPayloadSize; i > 0; --i) {
                buffer.put((byte)0);
            }
            ignore = false;
        }
        finally {
            transport.releaseSendBuffer(ignore, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeNotifyMessage(Transport transport, int sid, int ioid, TypeSupports.TypeSupport<T> typeSupport, T value, int count) {
        int calculatedPayloadSize = typeSupport.serializeSize(value, count);
        int alignedPayloadSize = Messages.calculateAlignedSize(8, calculatedPayloadSize);
        boolean ignore = true;
        try {
            ByteBuffer buffer = Messages.startCAMessage(transport, (short)19, alignedPayloadSize, (short)typeSupport.getDataType(), count, sid, ioid);
            typeSupport.serialize(buffer, value, count);
            for (int i = alignedPayloadSize - calculatedPayloadSize; i > 0; --i) {
                buffer.put((byte)0);
            }
            ignore = false;
        }
        finally {
            transport.releaseSendBuffer(ignore, false);
        }
    }
}

