/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas;

import com.cosylab.epics.caj.cas.CAJServerContext;
import com.cosylab.epics.caj.cas.handlers.BadResponse;
import com.cosylab.epics.caj.cas.handlers.ClearChannelResponse;
import com.cosylab.epics.caj.cas.handlers.CreateChannelResponse;
import com.cosylab.epics.caj.cas.handlers.EchoResponse;
import com.cosylab.epics.caj.cas.handlers.EventAddResponse;
import com.cosylab.epics.caj.cas.handlers.EventCancelResponse;
import com.cosylab.epics.caj.cas.handlers.EventsOffResponse;
import com.cosylab.epics.caj.cas.handlers.EventsOnResponse;
import com.cosylab.epics.caj.cas.handlers.HostnameResponse;
import com.cosylab.epics.caj.cas.handlers.NoopResponse;
import com.cosylab.epics.caj.cas.handlers.ReadNotifyResponse;
import com.cosylab.epics.caj.cas.handlers.SearchResponse;
import com.cosylab.epics.caj.cas.handlers.UsernameResponse;
import com.cosylab.epics.caj.cas.handlers.VersionResponse;
import com.cosylab.epics.caj.cas.handlers.WriteNotifyResponse;
import com.cosylab.epics.caj.cas.handlers.WriteResponse;
import com.cosylab.epics.caj.impl.ResponseHandler;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.util.HexDump;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public class CASResponseHandler
implements ResponseHandler {
    private ResponseHandler[] handlerTable;
    private CAJServerContext context;

    public CASResponseHandler(CAJServerContext context) {
        this.context = context;
        this.intializeHandlerTable();
    }

    private void intializeHandlerTable() {
        BadResponse badResponse = new BadResponse(this.context);
        this.handlerTable = new ResponseHandler[]{new VersionResponse(this.context), new EventAddResponse(this.context), new EventCancelResponse(this.context), badResponse, new WriteResponse(this.context), badResponse, new SearchResponse(this.context), badResponse, new EventsOffResponse(this.context), new EventsOnResponse(this.context), badResponse, badResponse, new ClearChannelResponse(this.context), badResponse, badResponse, new ReadNotifyResponse(this.context), new NoopResponse(this.context, "Read build request"), badResponse, new CreateChannelResponse(this.context), new WriteNotifyResponse(this.context), new UsernameResponse(this.context), new HostnameResponse(this.context), badResponse, new EchoResponse(this.context), badResponse, badResponse, badResponse, badResponse};
    }

    @Override
    public void handleResponse(InetSocketAddress responseFrom, Transport transport, ByteBuffer[] response) {
        ByteBuffer headerBuffer = response[0];
        int headerBufferSize = headerBuffer.limit() - headerBuffer.position();
        if (headerBufferSize < 16) {
            this.context.getLogger().fine("Invalid response header (16 bytes expected, " + headerBufferSize + " received) from " + responseFrom + ".");
            HexDump.hexDump("Invalid CA Header", headerBuffer.array(), headerBuffer.position(), headerBufferSize);
            headerBuffer.position(headerBuffer.limit());
            return;
        }
        short commandID = headerBuffer.getShort(headerBuffer.position());
        if (commandID < 0 || commandID >= this.handlerTable.length) {
            this.context.getLogger().fine("Invalid (or unsupported) command: " + commandID + ".");
            HexDump.hexDump("Invalid CA Header", headerBuffer.array(), headerBuffer.position(), headerBufferSize);
            headerBuffer.position(headerBuffer.limit());
            return;
        }
        this.handlerTable[commandID].handleResponse(responseFrom, transport, response);
    }
}

