/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas.handlers;

import com.cosylab.epics.caj.cas.CAJServerContext;
import com.cosylab.epics.caj.cas.CASTransport;
import com.cosylab.epics.caj.cas.handlers.AbstractCASResponseHandler;
import com.cosylab.epics.caj.cas.requests.EventCancelRequest;
import com.cosylab.epics.caj.impl.Transport;
import gov.aps.jca.CAStatus;
import gov.aps.jca.cas.ServerChannel;
import gov.aps.jca.cas.ServerMonitor;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class EventCancelResponse
extends AbstractCASResponseHandler {
    public EventCancelResponse(CAJServerContext context) {
        super(context, "Event cancel request");
    }

    @Override
    protected void internalHandleResponse(InetSocketAddress responseFrom, Transport transport, ByteBuffer[] response) {
        CASTransport casTransport = (CASTransport)transport;
        ServerChannel channel = casTransport.getChannel(this.parameter1);
        if (channel == null) {
            this.sendException(transport, this.parameter1, CAStatus.BADCHID, response[0], null);
            this.disconnect(transport);
            return;
        }
        ServerMonitor monitor = channel.getMonitor(this.parameter2);
        if (monitor == null) {
            this.sendException(transport, this.parameter1, CAStatus.BADMONID, response[0], null);
            this.disconnect(transport);
            return;
        }
        monitor.destroy();
        try {
            new EventCancelRequest(transport, this.parameter1, this.parameter2, this.dataType, this.dataCount).submit();
        }
        catch (Throwable th) {
            this.context.getLogger().log(Level.WARNING, "Exception caught when responding to event cancel request for channel with SID : " + this.parameter1, th);
        }
    }

    private void disconnect(Transport transport) {
        ((CASTransport)transport).close(true);
    }
}

