/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas.util;

import com.cosylab.epics.caj.cas.handlers.AbstractCASResponseHandler;
import gov.aps.jca.CAException;
import gov.aps.jca.CAStatus;
import gov.aps.jca.cas.ProcessVariable;
import gov.aps.jca.cas.ProcessVariableEventCallback;
import gov.aps.jca.cas.ProcessVariableReadCallback;
import gov.aps.jca.cas.ProcessVariableWriteCallback;
import gov.aps.jca.dbr.CTRL;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.GR;
import gov.aps.jca.dbr.LABELS;
import gov.aps.jca.dbr.PRECISION;
import gov.aps.jca.dbr.TIME;
import gov.aps.jca.dbr.TimeStamp;
import java.lang.reflect.Array;

public class MemoryProcessVariable
extends ProcessVariable {
    protected DBRType type;
    protected Object value;
    protected int count;
    protected TimeStamp timestamp;
    protected String units = "";
    protected Number upperDispLimit = GR.ZEROD;
    protected Number lowerDispLimit = GR.ZEROD;
    protected Number upperAlarmLimit = GR.ZEROD;
    protected Number upperWarningLimit = GR.ZEROD;
    protected Number lowerWarningLimit = GR.ZEROD;
    protected Number lowerAlarmLimit = GR.ZEROD;
    protected Number upperCtrlLimit = GR.ZEROD;
    protected Number lowerCtrlLimit = GR.ZEROD;
    protected short precision = (short)-1;
    protected String[] enumLabels = null;

    public MemoryProcessVariable(String name, ProcessVariableEventCallback eventCallback, DBRType type, Object initialValue) {
        super(name, eventCallback);
        if (!initialValue.getClass().isArray()) {
            throw new IllegalArgumentException("array expected as initialValue");
        }
        this.type = type;
        this.value = initialValue;
        this.count = Array.getLength(this.value);
        this.timestamp = new TimeStamp();
    }

    @Override
    public DBRType getType() {
        return this.type;
    }

    @Override
    public int getDimensionSize(int dimension) {
        if (dimension == 0) {
            return this.count;
        }
        return 0;
    }

    public Number getLowerAlarmLimit() {
        return this.lowerAlarmLimit;
    }

    public void setLowerAlarmLimit(Number lowerAlarmLimit) {
        this.lowerAlarmLimit = lowerAlarmLimit;
    }

    public Number getLowerCtrlLimit() {
        return this.lowerCtrlLimit;
    }

    public void setLowerCtrlLimit(Number lowerCtrlLimit) {
        this.lowerCtrlLimit = lowerCtrlLimit;
    }

    public Number getLowerDispLimit() {
        return this.lowerDispLimit;
    }

    public void setLowerDispLimit(Number lowerDispLimit) {
        this.lowerDispLimit = lowerDispLimit;
    }

    public Number getLowerWarningLimit() {
        return this.lowerWarningLimit;
    }

    public void setLowerWarningLimit(Number lowerWarningLimit) {
        this.lowerWarningLimit = lowerWarningLimit;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public Number getUpperAlarmLimit() {
        return this.upperAlarmLimit;
    }

    public void setUpperAlarmLimit(Number upperAlarmLimit) {
        this.upperAlarmLimit = upperAlarmLimit;
    }

    public Number getUpperCtrlLimit() {
        return this.upperCtrlLimit;
    }

    public void setUpperCtrlLimit(Number upperCtrlLimit) {
        this.upperCtrlLimit = upperCtrlLimit;
    }

    public Number getUpperDispLimit() {
        return this.upperDispLimit;
    }

    public void setUpperDispLimit(Number upperDispLimit) {
        this.upperDispLimit = upperDispLimit;
    }

    public Number getUpperWarningLimit() {
        return this.upperWarningLimit;
    }

    public void setUpperWarningLimit(Number upperWarningLimit) {
        this.upperWarningLimit = upperWarningLimit;
    }

    public short getPrecision() {
        return this.precision;
    }

    public void setPrecision(short precision) {
        this.precision = precision;
    }

    @Override
    public String[] getEnumLabels() {
        return this.enumLabels;
    }

    public void setEnumLabels(String[] labels) {
        this.enumLabels = labels;
    }

    @Override
    public synchronized CAStatus read(DBR value, ProcessVariableReadCallback asyncReadCallback) throws CAException {
        this.fillInDBR(value);
        ((TIME)((Object)value)).setTimeStamp(this.timestamp);
        int minCount = Math.min(this.count, value.getCount());
        System.arraycopy(this.value, 0, value.getValue(), 0, minCount);
        return CAStatus.NORMAL;
    }

    public void fillInDBR(DBR value) {
        if (value.isGR()) {
            GR gr = (GR)((Object)value);
            gr.setUnits(this.getUnits());
            gr.setUpperDispLimit(this.getUpperDispLimit());
            gr.setLowerDispLimit(this.getLowerDispLimit());
            gr.setUpperAlarmLimit(this.getUpperAlarmLimit());
            gr.setUpperWarningLimit(this.getUpperWarningLimit());
            gr.setLowerWarningLimit(this.getLowerWarningLimit());
            gr.setLowerAlarmLimit(this.getLowerAlarmLimit());
        }
        if (value.isCTRL()) {
            CTRL ctrl = (CTRL)((Object)value);
            ctrl.setUpperCtrlLimit(this.getUpperCtrlLimit());
            ctrl.setLowerCtrlLimit(this.getLowerCtrlLimit());
        }
        if (value.isPRECSION()) {
            PRECISION precision = (PRECISION)((Object)value);
            precision.setPrecision(this.getPrecision());
        }
        if (value.isLABELS()) {
            LABELS labels = (LABELS)((Object)value);
            labels.setLabels(this.getEnumLabels());
        }
    }

    @Override
    public synchronized CAStatus write(DBR value, ProcessVariableWriteCallback asyncWriteCallback) throws CAException {
        this.value = value.getValue();
        this.count = Array.getLength(this.value);
        this.timestamp = new TimeStamp();
        if (this.interest) {
            DBR monitorDBR = AbstractCASResponseHandler.createDBRforReading(this);
            this.fillInDBR(monitorDBR);
            ((TIME)((Object)monitorDBR)).setTimeStamp(this.timestamp);
            System.arraycopy(this.value, 0, monitorDBR.getValue(), 0, this.count);
            this.eventCallback.postEvent(3, monitorDBR);
        }
        return CAStatus.NORMAL;
    }
}

