/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas.util;

import gov.aps.jca.CAException;
import gov.aps.jca.CAStatus;
import gov.aps.jca.cas.ProcessVariable;
import gov.aps.jca.cas.ProcessVariableEventCallback;
import gov.aps.jca.cas.ProcessVariableReadCallback;
import gov.aps.jca.cas.ProcessVariableWriteCallback;
import gov.aps.jca.dbr.CTRL;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.GR;

public abstract class NumericProcessVariable
extends ProcessVariable {
    public NumericProcessVariable(String name, ProcessVariableEventCallback eventCallback) {
        super(name, eventCallback);
    }

    public String getUnits() {
        return "";
    }

    public Number getUpperDispLimit() {
        return GR.ZEROD;
    }

    public Number getLowerDispLimit() {
        return GR.ZEROD;
    }

    public Number getUpperAlarmLimit() {
        return GR.ZEROD;
    }

    public Number getUpperWarningLimit() {
        return GR.ZEROD;
    }

    public Number getLowerWarningLimit() {
        return GR.ZEROD;
    }

    public Number getLowerAlarmLimit() {
        return GR.ZEROD;
    }

    public Number getUpperCtrlLimit() {
        return GR.ZEROD;
    }

    public Number getLowerCtrlLimit() {
        return GR.ZEROD;
    }

    @Override
    public CAStatus read(DBR value, ProcessVariableReadCallback asyncReadCallback) throws CAException {
        this.fillInDBR(value);
        return this.readValue(value, asyncReadCallback);
    }

    public void fillInDBR(DBR value) {
        if (value.isGR()) {
            GR gr = (GR)((Object)value);
            gr.setUnits(this.getUnits());
            gr.setUpperDispLimit(this.getUpperDispLimit());
            gr.setLowerDispLimit(this.getLowerDispLimit());
            gr.setUpperAlarmLimit(this.getUpperAlarmLimit());
            gr.setUpperWarningLimit(this.getUpperWarningLimit());
            gr.setLowerWarningLimit(this.getLowerWarningLimit());
            gr.setLowerAlarmLimit(this.getLowerAlarmLimit());
        }
        if (value.isCTRL()) {
            CTRL ctrl = (CTRL)((Object)value);
            ctrl.setUpperCtrlLimit(this.getUpperCtrlLimit());
            ctrl.setLowerCtrlLimit(this.getLowerCtrlLimit());
        }
    }

    protected abstract CAStatus readValue(DBR var1, ProcessVariableReadCallback var2) throws CAException;

    @Override
    public CAStatus write(DBR value, ProcessVariableWriteCallback asyncWriteCallback) throws CAException {
        return this.writeValue(value, asyncWriteCallback);
    }

    protected abstract CAStatus writeValue(DBR var1, ProcessVariableWriteCallback var2) throws CAException;
}

