/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas.util.examples;

import com.cosylab.epics.caj.cas.handlers.AbstractCASResponseHandler;
import com.cosylab.epics.caj.cas.util.NumericProcessVariable;
import gov.aps.jca.CAException;
import gov.aps.jca.CAStatus;
import gov.aps.jca.cas.ProcessVariableEventCallback;
import gov.aps.jca.cas.ProcessVariableReadCallback;
import gov.aps.jca.cas.ProcessVariableWriteCallback;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.DBR_Int;
import gov.aps.jca.dbr.DBR_TIME_Int;
import gov.aps.jca.dbr.Severity;
import gov.aps.jca.dbr.Status;
import gov.aps.jca.dbr.TIME;
import gov.aps.jca.dbr.TimeStamp;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CounterProcessVariable
extends NumericProcessVariable
implements Runnable {
    private static final Logger logger = Logger.getLogger(CounterProcessVariable.class.getName());
    protected int startValue;
    protected int endValue;
    protected int incrementValue;
    protected int periodInMS;
    protected Number lowerWarningValue;
    protected Number upperWarningValue;
    protected Number lowerAlarmValue;
    protected Number upperAlarmValue;
    protected Number lowerDisplayValue;
    protected Number upperDisplayValue;
    protected Number lowerControlValue;
    protected Number upperControlValue;
    protected int value;
    protected TimeStamp timestamp;
    protected Status status;
    protected Severity severity;

    public CounterProcessVariable(String name, ProcessVariableEventCallback eventCallback, int startValue, int endValue, int incrementValue, int periodInMS, int lowerWarningValue, int upperWarningValue, int lowerAlarmValue, int upperAlarmValue) {
        super(name, eventCallback);
        this.startValue = startValue;
        this.endValue = endValue;
        this.incrementValue = incrementValue;
        this.periodInMS = periodInMS;
        this.lowerWarningValue = new Integer(lowerWarningValue);
        this.upperWarningValue = new Integer(upperWarningValue);
        this.lowerAlarmValue = new Integer(lowerAlarmValue);
        this.upperAlarmValue = new Integer(upperAlarmValue);
        this.lowerControlValue = new Integer(startValue);
        this.upperControlValue = new Integer(endValue);
        this.lowerDisplayValue = this.lowerControlValue;
        this.upperDisplayValue = this.upperControlValue;
        this.initialize();
    }

    protected void initialize() {
        this.value = this.startValue;
        this.timestamp = new TimeStamp();
        this.checkForAlarms();
        Thread thread = new Thread((Runnable)this, this.getName() + " counter");
        thread.setDaemon(true);
        thread.start();
    }

    protected void checkForAlarms() {
        this.severity = Severity.MINOR_ALARM;
        if (this.value >= this.upperAlarmValue.intValue()) {
            this.status = Status.HIHI_ALARM;
        } else if (this.value >= this.upperWarningValue.intValue()) {
            this.status = Status.HIGH_ALARM;
        } else if (this.value <= this.lowerAlarmValue.intValue()) {
            this.status = Status.LOLO_ALARM;
        } else if (this.value <= this.lowerWarningValue.intValue()) {
            this.status = Status.LOW_ALARM;
        } else {
            this.status = Status.NO_ALARM;
            this.severity = Severity.NO_ALARM;
        }
    }

    @Override
    public DBRType getType() {
        return DBRType.INT;
    }

    @Override
    public Number getLowerAlarmLimit() {
        return this.lowerAlarmValue;
    }

    @Override
    public Number getLowerCtrlLimit() {
        return this.lowerControlValue;
    }

    @Override
    public Number getLowerDispLimit() {
        return this.lowerDisplayValue;
    }

    @Override
    public Number getLowerWarningLimit() {
        return this.lowerWarningValue;
    }

    @Override
    public String getUnits() {
        return "";
    }

    @Override
    public Number getUpperAlarmLimit() {
        return this.upperAlarmValue;
    }

    @Override
    public Number getUpperCtrlLimit() {
        return this.upperControlValue;
    }

    @Override
    public Number getUpperDispLimit() {
        return this.upperDisplayValue;
    }

    @Override
    public Number getUpperWarningLimit() {
        return this.upperWarningValue;
    }

    @Override
    protected synchronized CAStatus readValue(DBR value, ProcessVariableReadCallback asyncReadCallback) throws CAException {
        DBR_TIME_Int timeDBR = (DBR_TIME_Int)value;
        this.fillInStatusAndTime(timeDBR);
        timeDBR.getIntValue()[0] = this.value;
        return CAStatus.NORMAL;
    }

    protected void fillInStatusAndTime(TIME timeDBR) {
        timeDBR.setStatus(this.status);
        timeDBR.setSeverity(this.severity);
        timeDBR.setTimeStamp(this.timestamp);
    }

    @Override
    protected synchronized CAStatus writeValue(DBR value, ProcessVariableWriteCallback asyncWriteCallback) throws CAException {
        DBR_Int intDBR = (DBR_Int)value;
        int val = intDBR.getIntValue()[0];
        if (val < this.startValue || val > this.endValue) {
            return CAStatus.PUTFAIL;
        }
        this.value = val;
        this.timestamp = new TimeStamp();
        this.checkForAlarms();
        if (this.interest) {
            int mask = 3;
            if (this.status != Status.NO_ALARM) {
                mask |= 4;
            }
            DBR monitorDBR = AbstractCASResponseHandler.createDBRforReading(this);
            ((DBR_Int)monitorDBR).getIntValue()[0] = this.value;
            this.fillInDBR(monitorDBR);
            this.fillInStatusAndTime((TIME)((Object)monitorDBR));
            this.eventCallback.postEvent(mask, monitorDBR);
        }
        return CAStatus.NORMAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DBR_Int valueHolder = new DBR_Int(1);
        int[] valueArray = valueHolder.getIntValue();
        while (!Thread.interrupted()) {
            try {
                Thread.sleep(this.periodInMS);
            }
            catch (InterruptedException e) {
                break;
            }
            CounterProcessVariable counterProcessVariable = this;
            synchronized (counterProcessVariable) {
                int newValue = this.value + this.incrementValue;
                if (newValue > this.endValue) {
                    newValue = this.startValue;
                }
                valueArray[0] = newValue;
                try {
                    this.write(valueHolder, null);
                }
                catch (CAException e) {
                    logger.log(Level.SEVERE, "", e);
                }
            }
        }
    }
}

