/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl.requests;

import com.cosylab.epics.caj.CAJChannel;
import com.cosylab.epics.caj.CAJContext;
import com.cosylab.epics.caj.impl.DBRDecoder;
import com.cosylab.epics.caj.impl.NotifyResponseRequest;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.requests.AbstractCARequest;
import gov.aps.jca.CAStatus;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.event.ContextExceptionEvent;
import gov.aps.jca.event.GetEvent;
import gov.aps.jca.event.GetListener;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ReadNotifyRequest
extends AbstractCARequest
implements NotifyResponseRequest {
    protected CAJContext context;
    protected int ioid;
    protected int sid;
    protected GetListener callback;
    protected DBR dbr;
    protected boolean sync;
    protected int sequenceNumberIO;
    protected CAJChannel channel;
    protected int requestedDataType;
    protected int requestedDataCount;
    protected boolean prohibitIOCancel = false;

    public ReadNotifyRequest(CAJChannel channel, GetListener callback, DBR dbr, Transport transport, int sid, int dataType, int dataCount) {
        super(transport);
        this.channel = channel;
        this.callback = callback;
        this.dbr = dbr;
        this.sid = sid;
        this.requestedDataType = dataType;
        if (dataCount == 0 && channel.getTransport().getMinorRevision() < 13) {
            dataCount = channel.getElementCount();
        }
        this.requestedDataCount = dataCount;
        this.sync = dbr != null;
        this.context = (CAJContext)transport.getContext();
        this.ioid = this.context.registerResponseRequest(this);
        channel.registerResponseRequest(this);
        this.requestMessage = ReadNotifyRequest.insertCAHeader(transport, null, (short)15, 0, (short)dataType, dataCount, sid, this.ioid);
    }

    @Override
    public int getIOID() {
        return this.ioid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void response(int status, short dataType, int dataCount, ByteBuffer dataPayloadBuffer) {
        try {
            CAStatus caStatus = CAStatus.forStatusCode(status);
            if (caStatus == CAStatus.NORMAL) {
                this.dbr = DBRDecoder.getDBR(this.dbr, dataType, dataCount, dataPayloadBuffer);
            } else {
                this.prohibitIOCancel = true;
            }
            if (this.callback != null) {
                this.context.getEventDispatcher().dispatch(new GetEvent(this.channel, this.dbr, caStatus), this.callback);
            }
        }
        finally {
            this.cancel();
        }
    }

    @Override
    public void submit() throws IOException {
        super.submit();
        if (this.sync) {
            this.sequenceNumberIO = this.context.incrementPendingRequests();
        }
    }

    @Override
    public void cancel() {
        boolean alreadyCanceled;
        boolean bl = alreadyCanceled = this.context.unregisterResponseRequest(this) == null;
        if (!alreadyCanceled && this.sync && !this.prohibitIOCancel) {
            this.context.decrementPendingRequests(this.sequenceNumberIO);
        }
        this.channel.unregisterResponseRequest(this);
    }

    @Override
    public void timeout() {
        this.prohibitIOCancel = true;
        this.cancel();
        if (this.callback != null) {
            this.context.getEventDispatcher().dispatch(new GetEvent(this.channel, null, CAStatus.TIMEOUT), this.callback);
        }
    }

    @Override
    public void exception(int errorCode, String errorMessage) {
        CAStatus status;
        this.prohibitIOCancel = true;
        this.cancel();
        if (errorMessage == null && (status = CAStatus.forStatusCode(errorCode)) != null) {
            errorMessage = status.getMessage();
        }
        ContextExceptionEvent cee = new ContextExceptionEvent(this.context, this.channel, DBRType.forValue(this.requestedDataType), this.requestedDataCount, this.dbr, errorMessage);
        this.context.notifyException(cee);
    }
}

