/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.dbr;

import gov.aps.jca.CAStatus;
import gov.aps.jca.CAStatusException;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRFactory;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.DBR_Byte;
import gov.aps.jca.dbr.DBR_Double;
import gov.aps.jca.dbr.DBR_Enum;
import gov.aps.jca.dbr.DBR_Int;
import gov.aps.jca.dbr.DBR_Short;
import gov.aps.jca.dbr.DBR_String;
import gov.aps.jca.dbr.FLOAT;
import gov.aps.jca.dbr.PRECISION;
import java.util.Locale;

public class DBR_Float
extends DBR
implements FLOAT {
    public static final DBRType TYPE = new DBRType("DBR_FLOAT", 2, DBR_Float.class);

    public DBR_Float() {
        this(1);
    }

    public DBR_Float(int count) {
        this(new float[count]);
    }

    public DBR_Float(float[] value) {
        super(value);
    }

    @Override
    public DBRType getType() {
        return TYPE;
    }

    @Override
    public float[] getFloatValue() {
        return (float[])this.getValue();
    }

    @Override
    public DBR convert(DBRType convertType) throws CAStatusException {
        if (convertType.isFLOAT() && convertType.getValue() <= this.getType().getValue()) {
            return this;
        }
        float[] fromValue = this.getFloatValue();
        DBR dbr = DBRFactory.create(convertType, this._count);
        if (convertType.isSTRING()) {
            String[] toValue = ((DBR_String)dbr).getStringValue();
            int decimals = -1;
            if (this.isPRECSION()) {
                decimals = ((PRECISION)((Object)this)).getPrecision();
            }
            if (decimals >= 0) {
                String formatFString = "%." + decimals + "f";
                for (int i2 = 0; i2 < this._count; ++i2) {
                    Object[] params = new Object[]{new Float(fromValue[i2])};
                    toValue[i2] = String.format(Locale.US, formatFString, params);
                    if (toValue[i2].length() <= 16) continue;
                    String formatEString = "%." + decimals + "e";
                    toValue[i2] = String.format(Locale.US, formatEString, params);
                }
            } else {
                for (int i3 = 0; i3 < this._count; ++i3) {
                    toValue[i3] = String.valueOf(fromValue[i3]);
                }
            }
        } else if (convertType.isSHORT()) {
            short[] toValue = ((DBR_Short)dbr).getShortValue();
            for (int i4 = 0; i4 < this._count; ++i4) {
                toValue[i4] = (short)fromValue[i4];
            }
        } else if (convertType.isFLOAT()) {
            float[] toValue = ((DBR_Float)dbr).getFloatValue();
            for (int i5 = 0; i5 < this._count; ++i5) {
                toValue[i5] = fromValue[i5];
            }
        } else if (convertType.isENUM()) {
            short[] toValue = ((DBR_Enum)dbr).getEnumValue();
            for (int i6 = 0; i6 < this._count; ++i6) {
                toValue[i6] = (short)fromValue[i6];
            }
        } else if (convertType.isBYTE()) {
            byte[] toValue = ((DBR_Byte)dbr).getByteValue();
            for (int i7 = 0; i7 < this._count; ++i7) {
                toValue[i7] = (byte)fromValue[i7];
            }
        } else if (convertType.isINT()) {
            int[] toValue = ((DBR_Int)dbr).getIntValue();
            for (int i8 = 0; i8 < this._count; ++i8) {
                toValue[i8] = (int)fromValue[i8];
            }
        } else if (convertType.isDOUBLE()) {
            double[] toValue = ((DBR_Double)dbr).getDoubleValue();
            for (int i9 = 0; i9 < this._count; ++i9) {
                toValue[i9] = fromValue[i9];
            }
        } else {
            throw new CAStatusException(CAStatus.NOCONVERT, "converstion not supported");
        }
        return dbr;
    }
}

