/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.commons.lang3.time.StopWatch;
import org.epics.ca.Channel;
import org.epics.ca.Context;
import org.epics.ca.EpicsChannelAccessTestServer;
import org.epics.ca.Monitor;
import org.epics.ca.NotificationConsumer;
import org.epics.ca.ThreadWatcher;
import org.epics.ca.impl.JavaProcessManager;
import org.epics.ca.impl.monitor.MonitorNotificationServiceFactoryCreator;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.util.logging.LibraryLogManager;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

class ChannelThroughputTests {
    private static final Logger logger = LibraryLogManager.getLogger(ChannelThroughputTests.class);
    private ThreadWatcher threadWatcher;
    private JavaProcessManager processManager;

    ChannelThroughputTests() {
    }

    @BeforeAll
    static void beforeAll() {
        MatcherAssert.assertThat(NetworkUtilities.verifyTargetPlatformNetworkStackIsChannelAccessCompatible(), Is.is(true));
        if (NetworkUtilities.isVpnActive()) {
            Assertions.fail("This test is not supported when a VPN connection is active on the local network interface.");
        }
    }

    @BeforeEach
    void beforeEach() {
        this.threadWatcher = ThreadWatcher.start();
        EpicsChannelAccessTestServer.start();
    }

    @AfterEach
    void afterEach() {
        EpicsChannelAccessTestServer.shutdown();
        this.threadWatcher.verify();
    }

    @ParameterizedTest
    @ValueSource(ints={1, 10, 100, 1000, 2000, 5000})
    void testGet(int numberOfGets) {
        logger.info(String.format("Starting Get throughput test for %d CA gets", numberOfGets));
        try (Context context = new Context();){
            Channel<Integer> channel = context.createChannel("adc01", Integer.class);
            channel.connect();
            StopWatch stopWatch = StopWatch.createStarted();
            for (int i2 = 0; i2 < numberOfGets; ++i2) {
                channel.get();
            }
            long elapseTimeInMilliseconds = stopWatch.getTime(TimeUnit.MILLISECONDS);
            logger.info("RESULTS:");
            logger.info(String.format("- Synchronous Get with %d gets took %s ms. Average: %3f ms.", numberOfGets, elapseTimeInMilliseconds, Float.valueOf((float)elapseTimeInMilliseconds / (float)numberOfGets)));
            logger.info("");
        }
    }

    @ParameterizedTest
    @ValueSource(ints={1, 10, 100, 1000, 2000, 5000})
    void testPutAndGet(int numberOfPutsAndGets) {
        try (Context context = new Context();){
            logger.info(String.format("Starting PutAndGet throughput test for %d CA puts/gets", numberOfPutsAndGets));
            Channel<Integer> channel = context.createChannel("adc01", Integer.class);
            channel.connect();
            StopWatch stopWatch = StopWatch.createStarted();
            for (int i2 = 0; i2 < numberOfPutsAndGets; ++i2) {
                channel.get();
            }
            long elapseTimeInMilliseconds = stopWatch.getTime(TimeUnit.MILLISECONDS);
            logger.info("RESULTS:");
            logger.info(String.format("- Synchronous PutAndGet with %d puts/gets took %s ms. Average: %3f ms.", numberOfPutsAndGets, elapseTimeInMilliseconds, Float.valueOf((float)elapseTimeInMilliseconds / (float)numberOfPutsAndGets)));
            logger.info("");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getArgumentsForTestPutAndMonitor"})
    void testPutAndMonitor(String serviceImpl, int numberOfPuts) {
        logger.info(String.format("Starting PutAndMonitor throughput test using monitor notification impl: '%s' and for %d CA puts", serviceImpl, numberOfPuts));
        Properties contextProperties = new Properties();
        contextProperties.setProperty("CA_MONITOR_NOTIFIER_IMPL", serviceImpl);
        try (Context context = new Context(contextProperties);){
            Channel<Integer> channel = context.createChannel("adc01", Integer.class);
            channel.connect();
            NotificationConsumer<Integer> notificationConsumer = NotificationConsumer.getNormalConsumer();
            notificationConsumer.clearCurrentNotificationCount();
            notificationConsumer.setExpectedNotificationCount(1);
            Monitor<Integer> monitor = channel.addValueMonitor(notificationConsumer);
            notificationConsumer.awaitExpectedNotificationCount();
            notificationConsumer.clearCurrentNotificationCount();
            StopWatch notificationDeliveryMeasurementStopWatch = StopWatch.createStarted();
            for (int i2 = 0; i2 < numberOfPuts; ++i2) {
                channel.put(i2);
            }
            Integer endOfSequence = -1;
            notificationConsumer.setExpectedNotificationValue(endOfSequence);
            StopWatch latencyMeasurementStopWatch = StopWatch.createStarted();
            channel.put(endOfSequence);
            notificationConsumer.awaitExpectedNotificationValue();
            long multipleNotificationDeliveryTimeInMilliseconds = notificationDeliveryMeasurementStopWatch.getTime(TimeUnit.MILLISECONDS);
            long singleNotificationDeliveryLatencyInMicroseconds = latencyMeasurementStopWatch.getTime(TimeUnit.MICROSECONDS);
            logger.info("RESULTS:");
            logger.info(String.format("- The test consumer received: %d notifications", notificationConsumer.getCurrentNotificationCount()));
            logger.info(String.format("- The delivery latency was typically %d us", singleNotificationDeliveryLatencyInMicroseconds));
            logger.info(String.format("- Synchronous PutAndMonitor with %d puts took %s ms. Average: %3f ms.", numberOfPuts, multipleNotificationDeliveryTimeInMilliseconds, Float.valueOf((float)multipleNotificationDeliveryTimeInMilliseconds / (float)numberOfPuts)));
            logger.info("");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getArgumentsForTestFastCounterMonitor"})
    void testFastCounterMonitor(String serviceImpl, int numberOfNotifications) {
        logger.info(String.format("Starting FastCounterMonitor throughput test using impl: '%s'and for '%d' notifications...", serviceImpl, numberOfNotifications));
        Properties contextProperties = new Properties();
        contextProperties.setProperty("CA_MONITOR_NOTIFIER_IMPL", serviceImpl);
        try (Context context = new Context(contextProperties);){
            Channel<Integer> channel = context.createChannel("1msCounter", Integer.class);
            channel.connect();
            ArrayList<Monitor<Integer>> monitorList = new ArrayList<Monitor<Integer>>();
            boolean numberOfMonitors = true;
            for (int i2 = 0; i2 < 1; ++i2) {
                NotificationConsumer notificationConsumer = NotificationConsumer.getNormalConsumer();
                monitorList.add(channel.addValueMonitor(notificationConsumer));
            }
            int totalNotificationCount = numberOfNotifications * 1;
            NotificationConsumer.setExpectedTotalNotificationCount(totalNotificationCount);
            NotificationConsumer.clearCurrentTotalNotificationCount();
            StopWatch stopWatch = StopWatch.createStarted();
            NotificationConsumer.awaitExpectedTotalNotificationCount();
            long elapsedTimeInMilliseconds = stopWatch.getTime(TimeUnit.MILLISECONDS);
            monitorList.forEach(Monitor::close);
            monitorList.clear();
            logger.info("RESULTS:");
            logger.info(String.format("- The test consumer received: %d notifications", NotificationConsumer.getCurrentTotalNotificationCount()));
            logger.info(String.format("- FastCounterMonitor with %d notifications took %s ms. Average: %3f ms.", totalNotificationCount, elapsedTimeInMilliseconds, Float.valueOf((float)elapsedTimeInMilliseconds / (float)totalNotificationCount)));
            logger.info("");
        }
    }

    private static Stream<Arguments> getArgumentsForTestPutAndMonitor() {
        List<String> serviceImpls = MonitorNotificationServiceFactoryCreator.getAllServiceImplementations();
        List<Integer> numberOfPuts = Arrays.asList(100, 2000);
        return serviceImpls.stream().flatMap(s -> numberOfPuts.stream().map(n -> Arguments.of(s, n)));
    }

    private static Stream<Arguments> getArgumentsForTestFastCounterMonitor() {
        List<String> serviceImpls = MonitorNotificationServiceFactoryCreator.getAllServiceImplementations();
        List<Integer> notifications = Arrays.asList(100, 2000);
        return serviceImpls.stream().flatMap(s -> notifications.stream().map(n -> Arguments.of(s, n)));
    }
}

