/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca;

import com.cosylab.epics.caj.cas.util.DefaultServerImpl;
import com.cosylab.epics.caj.cas.util.MemoryProcessVariable;
import com.cosylab.epics.caj.cas.util.examples.CounterProcessVariable;
import gov.aps.jca.CAException;
import gov.aps.jca.JCALibrary;
import gov.aps.jca.cas.Server;
import gov.aps.jca.cas.ServerContext;
import gov.aps.jca.dbr.DBR_Double;
import gov.aps.jca.dbr.DBR_Enum;
import gov.aps.jca.dbr.DBR_Int;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.epics.ca.impl.JavaProcessManager;
import org.epics.ca.util.logging.LibraryLogManager;

public class EpicsChannelAccessTestServer {
    private static final Logger logger = LibraryLogManager.getLogger(EpicsChannelAccessTestServer.class);
    private static final AtomicReference<JavaProcessManager> processManagerRef = new AtomicReference();
    private final ServerContext context;

    public static void main(String[] args) {
        EpicsChannelAccessTestServer epicsChannelAccessTestServer;
        logger.info("The EPICS Channel Access Test Server is starting...");
        try {
            epicsChannelAccessTestServer = new EpicsChannelAccessTestServer();
        }
        catch (CAException ex) {
            String msg = "An exception occurred which prevented the server from starting.";
            logger.log(Level.WARNING, "An exception occurred which prevented the server from starting.", ex);
            throw new RuntimeException("An exception occurred which prevented the server from starting.");
        }
        epicsChannelAccessTestServer.printContextInfo();
        epicsChannelAccessTestServer.run();
        logger.info("The EPICS Channel Access Test Server was initialised and is running.\n");
    }

    private EpicsChannelAccessTestServer() throws CAException {
        System.setProperty("EPICS_CA_ADDR_LIST", "localhost");
        JCALibrary jca = JCALibrary.getInstance();
        DefaultServerImpl server = new DefaultServerImpl();
        this.context = jca.createServerContext("com.cosylab.epics.caj.cas.CAJServerContext", (Server)server);
        this.registerProcessVariables(server);
    }

    public static void start() {
        Validate.validState(!EpicsChannelAccessTestServer.isStarted(), "The EpicsChanneAccessTestServer was not shutdown.", new Object[0]);
        Properties properties = new Properties();
        properties.setProperty("com.cosylab.epics.caj.cas.CAJServerContext.max_array_bytes", String.valueOf(0x400420));
        String[] noProgramArgs = new String[]{};
        JavaProcessManager processManager = new JavaProcessManager(EpicsChannelAccessTestServer.class, properties, noProgramArgs);
        processManager.start(true);
        processManagerRef.set(processManager);
    }

    public static void shutdown() {
        Validate.validState(EpicsChannelAccessTestServer.isStarted(), "The EpicsChanneAccessTestServer was not started.", new Object[0]);
        processManagerRef.get().shutdown();
        processManagerRef.set(null);
    }

    private static boolean isStarted() {
        return processManagerRef.get() != null;
    }

    void run() {
        try {
            this.context.run(0);
        }
        catch (CAException ex) {
            String msg = "The following unexpected exception occurred:";
            logger.log(Level.WARNING, "The following unexpected exception occurred:", ex);
            throw new RuntimeException("The following unexpected exception occurred:", ex);
        }
        logger.info("Done");
    }

    private void printContextInfo() {
        logger.info(this.context.getVersion().getVersionString());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(os, true);
        this.context.printInfo(printStream);
        printStream.close();
        try (InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(os.toByteArray()));
             BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                logger.info(line);
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Exception reading stream", ex);
        }
    }

    private void destroyContextWithoutPropagatingExceptions() {
        try {
            logger.finer("Destroying context.");
            this.context.destroy();
            logger.finer("Context was destroyed.");
        }
        catch (CAException | IllegalStateException ex) {
            logger.log(Level.WARNING, "Context destroy operation raised exception. Will interrupt calling thread.", ex);
            Thread.currentThread().interrupt();
        }
    }

    private void registerProcessVariables(DefaultServerImpl server) {
        server.createMemoryProcessVariable("simple", DBR_Int.TYPE, new int[]{1, 2, 3});
        MemoryProcessVariable mpv = new MemoryProcessVariable("adc01", null, DBR_Double.TYPE, new double[]{12.08, 3.11});
        mpv.setUpperDispLimit(10.0);
        mpv.setLowerDispLimit(-10.0);
        mpv.setUpperAlarmLimit(9.0);
        mpv.setLowerAlarmLimit(-9.0);
        mpv.setUpperCtrlLimit(8.0);
        mpv.setLowerCtrlLimit(-8.0);
        mpv.setUpperWarningLimit(7.0);
        mpv.setLowerWarningLimit(-7.0);
        mpv.setUnits("units");
        mpv.setPrecision((short)3);
        server.registerProcessVaribale(mpv);
        MemoryProcessVariable mpv2 = new MemoryProcessVariable("adc02", null, DBR_Double.TYPE, new double[]{1.04, 33.31});
        server.registerProcessVaribale(mpv2);
        MemoryProcessVariable mpv3 = new MemoryProcessVariable("adc03", null, DBR_Double.TYPE, new double[]{19.78, 53.11});
        server.registerProcessVaribale(mpv3);
        MemoryProcessVariable mpv4 = new MemoryProcessVariable("adc04", null, DBR_Double.TYPE, new double[]{19.78, 53.11});
        server.registerProcessVaribale(mpv4);
        MemoryProcessVariable enumPV = new MemoryProcessVariable("enum", null, DBR_Enum.TYPE, new short[]{3, 1}){
            private final String[] labels;
            {
                this.labels = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven"};
            }

            @Override
            public String[] getEnumLabels() {
                return this.labels;
            }
        };
        server.registerProcessVaribale(enumPV);
        CounterProcessVariable counter = new CounterProcessVariable("100msCounter", null, -10, 10, 1, 100, -7, 7, -9, 9);
        server.registerProcessVaribale(counter);
        CounterProcessVariable fastCounter = new CounterProcessVariable("1msCounter", null, Integer.MIN_VALUE, Integer.MAX_VALUE, 1, 1, -7, 7, -9, 9);
        server.registerProcessVaribale(fastCounter);
        int[] arrayValue = new int[0x100000];
        for (int i2 = 0; i2 < arrayValue.length; ++i2) {
            arrayValue[i2] = i2;
        }
        server.createMemoryProcessVariable("large", DBR_Int.TYPE, arrayValue);
    }
}

