/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca;

import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.time.StopWatch;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.util.logging.LibraryLogManager;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.LoggingListener;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

public class TargetPlatformTestRunner {
    private static final Logger logger = LibraryLogManager.getLogger(TargetPlatformTestRunner.class);
    private final SummaryGeneratingListener summaryGeneratingListener = new SummaryGeneratingListener();
    private final TestExecutionListener loggingListener;

    public static void main(String[] args) {
        if (!NetworkUtilities.verifyTargetPlatformNetworkStackIsChannelAccessCompatible()) {
            return;
        }
        TargetPlatformTestRunner runner = new TargetPlatformTestRunner();
        if (args.length != 0 && args.length != 2) {
            TargetPlatformTestRunner.printUsage();
            return;
        }
        if (args.length == 0) {
            runner.runTests("-ALL", "");
        } else {
            runner.runTests(args[0], args[1]);
        }
        TestExecutionSummary summary = runner.getSummary();
        summary.printTo(new PrintWriter(System.out));
    }

    public TargetPlatformTestRunner() {
        String debugProperty = System.getProperty("TARGET_PLATFORM_TEST_RUNNER_LOG_LEVEL", Level.INFO.toString());
        Level logLevel = Level.parse(debugProperty);
        this.loggingListener = LoggingListener.forJavaUtilLogging(logLevel);
    }

    private TestExecutionSummary getSummary() {
        return this.summaryGeneratingListener.getSummary();
    }

    private static void printUsage() {
        System.out.println("\nUsage: java -cp ca-x.y.z-all-with-tests.jar org.epics.ca.TargetPlatformTestRunner [{-package|-class|-method} testSelector]\n");
        System.out.println("Concrete Examples:");
        System.out.println("[1] Run all the tests in the library.");
        System.out.println("java -cp ca-1.2.3-all-with-tests.jar org.epics.ca.TargetPlatformTestRunner\n");
        System.out.println("\n");
        System.out.println("[2] Run all the tests in the package named 'repeater'.");
        System.out.println("java -cp ca-1.2.3-all-with-tests.jar org.epics.ca.TargetPlatformTestRunner -package org.epics.ca.impl.repeater\n");
        System.out.println("\n");
        System.out.println("[3] Run all the tests in the class named 'org.epics.ca.impl.repeater.UdpSocketUtilitiesTest'.");
        System.out.println("java -cp ca-1.2.3-all-with-tests.jar -class org.epics.ca.impl.repeater.UdpSocketUtilitiesTest\n");
        System.out.println("\n");
        System.out.println("[4] Run the test with the method named 'org.epics.ca.impl.repeater.UdpSocketUtilitiesTest#integrationTestDataTransfer'.");
        System.out.println("java -cp ca-1.2.3-all-with-tests.jar org.epics.ca.TargetPlatformTestRunner -method org.epics.ca.impl.repeater.UdpSocketUtilitiesTest#integrationTestDataTransfer\n");
        System.out.println("\n");
        System.exit(0);
    }

    private void runTests(String testType, String testSpecifier) {
        LauncherDiscoveryRequest request;
        switch (testType.toUpperCase()) {
            case "-ALL": {
                request = LauncherDiscoveryRequestBuilder.request().selectors(DiscoverySelectors.selectPackage("org.epics.ca")).build();
                break;
            }
            case "-PACKAGE": {
                request = LauncherDiscoveryRequestBuilder.request().selectors(DiscoverySelectors.selectPackage(testSpecifier)).build();
                break;
            }
            case "-CLASS": {
                request = LauncherDiscoveryRequestBuilder.request().selectors(DiscoverySelectors.selectClass(testSpecifier)).build();
                break;
            }
            case "-METHOD": {
                request = LauncherDiscoveryRequestBuilder.request().selectors(DiscoverySelectors.selectMethod(testSpecifier)).build();
                break;
            }
            default: {
                TargetPlatformTestRunner.printUsage();
                return;
            }
        }
        Launcher launcher = LauncherFactory.create();
        TestPlan testPlan = launcher.discover(request);
        launcher.registerTestExecutionListeners(this.summaryGeneratingListener);
        launcher.registerTestExecutionListeners(this.loggingListener);
        try {
            StopWatch stopWatch = StopWatch.createStarted();
            logger.info("RUNNING TEST(S)...");
            launcher.execute(testPlan, new TestExecutionListener[0]);
            stopWatch.stop();
            logger.info("TEST(S) COMPLETED. Elapsed time was: '" + stopWatch.toString() + "'.");
        }
        catch (RuntimeException ex) {
            logger.info("TEST(S) FAILED WITH EXCEPTION.");
        }
    }
}

