/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.epics.ca.impl.ProtocolConfiguration;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;

class ProtocolConfigurationTest {
    ProtocolConfigurationTest() {
    }

    @Test
    void testDefaults() {
        ProtocolConfiguration instance = new ProtocolConfiguration();
        MatcherAssert.assertThat(instance, Is.is(Matchers.notNullValue()));
        MatcherAssert.assertThat(instance.getAddressList(), Is.is(""));
        MatcherAssert.assertThat(instance.getAutoAddressList(), Is.is(true));
        MatcherAssert.assertThat(Float.valueOf(instance.getConnectionTimeout()), Is.is(Float.valueOf(30.0f)));
        MatcherAssert.assertThat(instance.getMaxArrayBytes(), Is.is(0));
        MatcherAssert.assertThat(instance.getRepeaterPort(), Is.is(5065));
        MatcherAssert.assertThat(instance.getServerPort(), Is.is(5064));
    }

    @Test
    void testSystemPropertyOverrides() {
        Properties propertyOverrides = new Properties();
        propertyOverrides.setProperty(ProtocolConfiguration.PropertyNames.EPICS_CA_ADDR_LIST.name(), "abcd");
        propertyOverrides.setProperty(ProtocolConfiguration.PropertyNames.EPICS_CA_AUTO_ADDR_LIST.name(), "false");
        propertyOverrides.setProperty(ProtocolConfiguration.PropertyNames.EPICS_CA_CONN_TMO.name(), "21.3");
        propertyOverrides.setProperty(ProtocolConfiguration.PropertyNames.EPICS_CA_MAX_ARRAY_BYTES.name(), "123456");
        propertyOverrides.setProperty(ProtocolConfiguration.PropertyNames.EPICS_CA_REPEATER_PORT.name(), "5421");
        propertyOverrides.setProperty(ProtocolConfiguration.PropertyNames.EPICS_CA_SERVER_PORT.name(), "9977");
        ProtocolConfiguration instance = new ProtocolConfiguration(propertyOverrides);
        MatcherAssert.assertThat(instance, Is.is(Matchers.notNullValue()));
        MatcherAssert.assertThat(instance.getAddressList(), Is.is("abcd"));
        MatcherAssert.assertThat(instance.getAutoAddressList(), Is.is(false));
        MatcherAssert.assertThat(Double.valueOf(instance.getConnectionTimeout()), Matchers.closeTo(21.3, 1.0E-5));
        MatcherAssert.assertThat(instance.getMaxArrayBytes(), Is.is(123456));
        MatcherAssert.assertThat(instance.getRepeaterPort(), Is.is(5421));
        MatcherAssert.assertThat(instance.getServerPort(), Is.is(9977));
    }

    @EnabledOnOs(value={OS.MAC, OS.LINUX})
    @Test
    void testEnvironmentalVariablesOverrides() throws Exception {
        HashMap<String, String> envMap = new HashMap<String, String>();
        envMap.put(ProtocolConfiguration.PropertyNames.EPICS_CA_ADDR_LIST.name(), "xyz");
        envMap.put(ProtocolConfiguration.PropertyNames.EPICS_CA_CONN_TMO.name(), "19.2");
        ProtocolConfigurationTest.setEnv(envMap);
        Properties propertyOverrides = new Properties();
        propertyOverrides.setProperty(ProtocolConfiguration.PropertyNames.EPICS_CA_CONN_TMO.name(), "21.3");
        ProtocolConfiguration instance = new ProtocolConfiguration(propertyOverrides);
        MatcherAssert.assertThat(instance, Is.is(Matchers.notNullValue()));
        MatcherAssert.assertThat(instance.getAddressList(), Is.is("xyz"));
        MatcherAssert.assertThat(Double.valueOf(instance.getConnectionTimeout()), Matchers.closeTo(21.3, 1.0E-5));
        envMap.clear();
        ProtocolConfigurationTest.setEnv(envMap);
    }

    private static void setEnv(Map<String, String> newenv) throws Exception {
        try {
            Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
            Field theEnvironmentField = processEnvironmentClass.getDeclaredField("theEnvironment");
            theEnvironmentField.setAccessible(true);
            Map env = (Map)theEnvironmentField.get(null);
            env.putAll(newenv);
            Field theCaseInsensitiveEnvironmentField = processEnvironmentClass.getDeclaredField("theCaseInsensitiveEnvironment");
            theCaseInsensitiveEnvironmentField.setAccessible(true);
            Map cienv = (Map)theCaseInsensitiveEnvironmentField.get(null);
            cienv.putAll(newenv);
        }
        catch (NoSuchFieldException e) {
            Class<?>[] classes = Collections.class.getDeclaredClasses();
            Map<String, String> env = System.getenv();
            for (Class<?> cl : classes) {
                if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
                Field field = cl.getDeclaredField("m");
                field.setAccessible(true);
                Object obj = field.get(env);
                Map map = (Map)obj;
                map.clear();
                map.putAll(newenv);
            }
        }
    }
}

