/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.monitor;

import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.epics.ca.ThreadWatcher;
import org.epics.ca.impl.monitor.MonitorNotificationService;
import org.epics.ca.impl.monitor.MonitorNotificationServiceFactory;
import org.epics.ca.impl.monitor.MonitorNotificationServiceFactoryCreator;
import org.epics.ca.util.logging.LibraryLogManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class MonitorNotificationServiceFactoryCreatorTest {
    private static final Logger logger = LibraryLogManager.getLogger(MonitorNotificationServiceFactoryCreatorTest.class);
    private ThreadWatcher threadWatcher;

    MonitorNotificationServiceFactoryCreatorTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.threadWatcher = ThreadWatcher.start();
    }

    @AfterEach
    void afterEach() {
        this.threadWatcher.verify();
    }

    @Test
    void testCreateMonitorNotificationServiceFactory_ThrowsNullPointerExceptionWhenServiceImplConfigurationNull() {
        Assertions.assertThrows(NullPointerException.class, () -> MonitorNotificationServiceFactoryCreator.create(null));
    }

    @Test
    void testCreateMonitorNotificationServiceFactory_ThrowsIllegalArgumentExceptionWhenServiceImplConfigurationNotRecognised() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> MonitorNotificationServiceFactoryCreator.create("ThisConfigIsBananas"));
    }

    @MethodSource(value={"getMonitorNotificationServiceImplementations"})
    @ParameterizedTest
    void testCreateMonitorNotificationServiceFactory_expected_configurations_are_recognised(String serviceImpl) {
        try (MonitorNotificationServiceFactory factory = MonitorNotificationServiceFactoryCreator.create(serviceImpl);){
            Assertions.assertNotNull(factory);
        }
    }

    @MethodSource(value={"getArgumentsForTestMonitorNotificationServiceImpl_NumberOfServiceThreadsArgumentProcessing"})
    @ParameterizedTest
    void testMonitorNotificationServiceImpl_NumberOfServiceThreadsArgumentProcessing(String serviceImpl, int expectedThreads) {
        try (MonitorNotificationServiceFactory factory = MonitorNotificationServiceFactoryCreator.create(serviceImpl);){
            Assertions.assertEquals(expectedThreads, factory.getQosMetricNumberOfNotificationThreadsPerConsumer());
        }
    }

    @MethodSource(value={"getArgumentsForTestMonitorNotificationServiceImpl_BufferSizeArgumentProcessing"})
    @ParameterizedTest
    void testMonitorNotificationServiceImpl_BufferSizeArgumentProcessing(String serviceImpl, boolean expectedIsBuffered, int expectedBufferSize) {
        try (MonitorNotificationServiceFactory factory = MonitorNotificationServiceFactoryCreator.create(serviceImpl);){
            Assertions.assertEquals(expectedIsBuffered, factory.getQosMetricIsBuffered());
            Assertions.assertEquals(expectedBufferSize, factory.getQosMetricBufferSizePerConsumer());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getArgumentsForTestServiceImplBufferingBehaviour"})
    void testServiceImplBufferingBehaviour(String serviceImpl, boolean expectedResult) {
        try (MonitorNotificationServiceFactory factory = MonitorNotificationServiceFactoryCreator.create(serviceImpl);){
            Assertions.assertEquals(expectedResult, factory.getQosMetricIsBuffered());
        }
    }

    @MethodSource(value={"getMonitorNotificationServiceImplementations"})
    @ParameterizedTest
    void testServiceImplResourceDisposeBehaviour_checkFactoryAutoClose(String serviceImpl) {
        logger.info(String.format("Testing resource autoclose behaviour of service implementation: '%s'", serviceImpl + ",50"));
        ThreadWatcher threadWatcher = ThreadWatcher.start();
        try (MonitorNotificationServiceFactory factory = MonitorNotificationServiceFactoryCreator.create(serviceImpl + ",50");){
            MonitorNotificationService<Long> service = factory.getServiceForConsumer(v -> {});
            service.publish(123L);
        }
        threadWatcher.verify();
    }

    @MethodSource(value={"getMonitorNotificationServiceImplementations"})
    @ParameterizedTest
    void testServiceImplResourceDisposeBehaviour_checkFactoryManualClose(String serviceImpl) {
        logger.info(String.format("Testing resource autoclose behaviour of service implementation: '%s'", serviceImpl + ",50"));
        ThreadWatcher threadWatcher = ThreadWatcher.start();
        MonitorNotificationServiceFactory factory = MonitorNotificationServiceFactoryCreator.create(serviceImpl + ",50");
        MonitorNotificationService<Long> service = factory.getServiceForConsumer(v -> {});
        service.publish(123L);
        factory.close();
        threadWatcher.verify();
    }

    private static Stream<Arguments> getMonitorNotificationServiceImplementations() {
        List<String> allConfigurations = MonitorNotificationServiceFactoryCreator.getAllServiceImplementations();
        return allConfigurations.stream().map(xva$0 -> Arguments.of(xva$0));
    }

    private static Stream<Arguments> getArgumentsForTestMonitorNotificationServiceImpl_BufferSizeArgumentProcessing() {
        return Stream.of(Arguments.of("StripedExecutorServiceMonitorNotificationServiceImpl", true, Integer.MAX_VALUE), Arguments.of("StripedExecutorServiceMonitorNotificationServiceImpl,,100", true, Integer.MAX_VALUE), Arguments.of("StripedExecutorServiceMonitorNotificationServiceImpl,5,100", true, Integer.MAX_VALUE), Arguments.of("BlockingQueueSingleWorkerMonitorNotificationServiceImpl", true, Integer.MAX_VALUE), Arguments.of("BlockingQueueSingleWorkerMonitorNotificationServiceImpl,,1", false, 1), Arguments.of("BlockingQueueSingleWorkerMonitorNotificationServiceImpl,,22", true, 22), Arguments.of("BlockingQueueSingleWorkerMonitorNotificationServiceImpl,15,79", true, 79), Arguments.of("BlockingQueueMultipleWorkerMonitorNotificationServiceImpl,,1", false, 1), Arguments.of("BlockingQueueMultipleWorkerMonitorNotificationServiceImpl,,42", true, 42), Arguments.of("BlockingQueueMultipleWorkerMonitorNotificationServiceImpl,15,19", true, 19));
    }

    private static Stream<Arguments> getArgumentsForTestMonitorNotificationServiceImpl_NumberOfServiceThreadsArgumentProcessing() {
        return Stream.of(Arguments.of("StripedExecutorServiceMonitorNotificationServiceImpl", 10), Arguments.of("StripedExecutorServiceMonitorNotificationServiceImpl,66", 66), Arguments.of("StripedExecutorServiceMonitorNotificationServiceImpl,XXX", 10), Arguments.of("StripedExecutorServiceMonitorNotificationServiceImpl,XXX,YYY", 10), Arguments.of("BlockingQueueSingleWorkerMonitorNotificationServiceImpl", 1), Arguments.of("BlockingQueueMultipleWorkerMonitorNotificationServiceImpl", 10), Arguments.of("BlockingQueueMultipleWorkerMonitorNotificationServiceImpl,10", 10), Arguments.of("BlockingQueueMultipleWorkerMonitorNotificationServiceImpl,10,YYY", 10), Arguments.of("BlockingQueueMultipleWorkerMonitorNotificationServiceImpl,XXX", 10));
    }

    private static Stream<Arguments> getArgumentsForTestServiceImplBufferingBehaviour() {
        return Stream.of(Arguments.of(MonitorNotificationServiceFactoryCreator.HUMAN_CONSUMER_IMPL, false), Arguments.of(MonitorNotificationServiceFactoryCreator.MACHINE_CONSUMER_IMPL, true));
    }
}

