/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.monitor.striped;

import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.epics.ca.impl.TypeSupports;
import org.epics.ca.impl.monitor.MonitorNotificationService;
import org.epics.ca.impl.monitor.striped.StripedExecutorServiceMonitorNotificationServiceFactory;
import org.epics.ca.impl.monitor.striped.StripedMonitorNotificationTask;
import org.epics.ca.util.logging.LibraryLogManager;

public class StripedExecutorServiceMonitorNotificationService<T>
implements MonitorNotificationService<T> {
    private static final Logger logger = LibraryLogManager.getLogger(StripedExecutorServiceMonitorNotificationService.class);
    private final StripedExecutorServiceMonitorNotificationServiceFactory factory;
    private final Consumer<? super T> consumer;
    private final ExecutorService executorService;
    private T deserializedValue;

    StripedExecutorServiceMonitorNotificationService(StripedExecutorServiceMonitorNotificationServiceFactory factory, ExecutorService executor, Consumer<? super T> consumer) {
        this.factory = Validate.notNull(factory);
        this.executorService = Validate.notNull(executor);
        this.consumer = Validate.notNull(consumer);
        this.deserializedValue = null;
    }

    @Override
    public boolean publish(ByteBuffer dataBuffer, TypeSupports.TypeSupport<T> typeSupport, int dataCount) {
        Validate.notNull(dataBuffer);
        Validate.notNull(typeSupport);
        Validate.inclusiveBetween(0L, Integer.MAX_VALUE, dataCount);
        this.deserializedValue = typeSupport.deserialize(dataBuffer, this.deserializedValue, dataCount);
        return this.publish(this.deserializedValue);
    }

    @Override
    public boolean publish(T value) {
        StripedMonitorNotificationTask<T> task = new StripedMonitorNotificationTask<T>(this.consumer, value);
        logger.finest(String.format("Submitting task on stripe: '%s' ", task.getStripe()));
        this.executorService.submit(task);
        return true;
    }

    @Override
    public void init() {
    }

    @Override
    public void close() {
        logger.finest("Closing monitor notification service for consumer.");
    }
}

