/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.monitor.striped;

import eu.javaspecialists.tjsn.concurrency.stripedexecutor.StripedExecutorService;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.epics.ca.impl.monitor.MonitorNotificationService;
import org.epics.ca.impl.monitor.MonitorNotificationServiceFactory;
import org.epics.ca.impl.monitor.MonitorNotificationServiceFactoryCreator;
import org.epics.ca.impl.monitor.striped.StripedExecutorServiceMonitorNotificationService;
import org.epics.ca.util.logging.LibraryLogManager;

public class StripedExecutorServiceMonitorNotificationServiceFactory
implements MonitorNotificationServiceFactory,
AutoCloseable {
    private static final Logger logger = LibraryLogManager.getLogger(StripedExecutorServiceMonitorNotificationServiceFactory.class);
    private final List<MonitorNotificationService<?>> serviceList = new ArrayList();
    private final StripedExecutorService stripedExecutorService;
    private final int numberOfThreads;

    public StripedExecutorServiceMonitorNotificationServiceFactory(int numberOfThreads) {
        Validate.inclusiveBetween(1L, Integer.MAX_VALUE, numberOfThreads);
        this.numberOfThreads = numberOfThreads;
        int numberOfThreadsBaseline = Thread.getAllStackTraces().keySet().size();
        logger.finest(String.format("The number of baseline threads in the system is: %d", numberOfThreadsBaseline));
        logger.fine(String.format("A StripedExecutorServiceMonitorNotificationServiceFactory is being created with %d threads and an unlimited notification entry buffer size...", numberOfThreads));
        this.stripedExecutorService = new StripedExecutorService(numberOfThreads);
    }

    @Override
    public <T> MonitorNotificationService<T> getServiceForConsumer(Consumer<? super T> consumer) {
        Validate.notNull(consumer);
        StripedExecutorServiceMonitorNotificationService<T> instance = new StripedExecutorServiceMonitorNotificationService<T>(this, this.stripedExecutorService, consumer);
        this.serviceList.add(instance);
        instance.init();
        return instance;
    }

    @Override
    public void close() {
        logger.finest(String.format("A StripedExecutorServiceMonitorNotificationServiceFactory is being closed with %d service entries...", this.getServiceCount()));
        for (MonitorNotificationService<?> service : this.serviceList) {
            service.close();
        }
        this.serviceList.clear();
        MonitorNotificationServiceFactoryCreator.shutdownExecutor(this.stripedExecutorService);
    }

    @Override
    public int getServiceCount() {
        return this.serviceList.size();
    }

    @Override
    public int getQosMetricNumberOfNotificationThreadsPerConsumer() {
        return this.numberOfThreads;
    }

    @Override
    public boolean getQosMetricIsNullPublishable() {
        return false;
    }

    @Override
    public boolean getQosMetricIsBuffered() {
        return true;
    }

    @Override
    public int getQosMetricBufferSizePerConsumer() {
        return Integer.MAX_VALUE;
    }
}

