/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.net.Inet4Address;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.epics.ca.impl.JavaProcessManager;
import org.epics.ca.impl.LibraryConfiguration;
import org.epics.ca.impl.repeater.CARepeater;
import org.epics.ca.impl.repeater.CARepeaterServiceManager;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.util.logging.LibraryLogManager;

class CARepeaterServiceInstance {
    private static final Logger logger = LibraryLogManager.getLogger(CARepeaterServiceInstance.class);
    private final int port;
    private JavaProcessManager processManager;

    CARepeaterServiceInstance(int port) {
        this.port = port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CARepeaterServiceInstance)) {
            return false;
        }
        CARepeaterServiceInstance that = (CARepeaterServiceInstance)o;
        return this.port == that.port;
    }

    public int hashCode() {
        return Objects.hash(this.port);
    }

    int getPort() {
        return this.port;
    }

    void start() {
        if (!LibraryConfiguration.getInstance().isRepeaterEnabled()) {
            logger.warning("The CA Repeater Service configuration is set to disabled.");
            return;
        }
        if (CARepeaterServiceManager.isRepeaterRunning(this.port)) {
            logger.warning("The CA Repeater is already running on port." + this.port);
            logger.warning("Possibly it was started previously by another process.");
            return;
        }
        if (this.processManager != null) {
            logger.severe("The CA Repeater is already running on port." + this.port);
            logger.severe("This is an unexpected condition which suggests a programming error.");
            return;
        }
        try {
            Level logLevel = LibraryConfiguration.getInstance().getRepeaterLogLevel();
            boolean outputCaptureEnable = LibraryConfiguration.getInstance().isRepeaterOutputCaptureEnabled();
            this.processManager = CARepeaterServiceInstance.startRepeater(this.port, logLevel, outputCaptureEnable);
        }
        catch (RuntimeException ex) {
            logger.warning("The CA Repeater on port " + this.port + " failed to start.");
        }
    }

    void shutdown() {
        if (!LibraryConfiguration.getInstance().isRepeaterEnabled()) {
            logger.warning("The CA Repeater Service configuration is set to disabled.");
            return;
        }
        if (!CARepeaterServiceManager.isRepeaterRunning(this.port)) {
            logger.warning("The CA Repeater is NOT already running on port." + this.port);
        }
        if (this.processManager == null) {
            logger.severe("The CA Repeater was never started on port." + this.port);
            logger.severe("This is an unexpected condition which suggests a programming error.");
            return;
        }
        if (!this.processManager.isAlive()) {
            logger.warning("The CA Repeater on port " + this.port + " has already died.");
        }
        if (!this.processManager.shutdown()) {
            logger.warning("The CA Repeater on port " + this.port + " failed to shutdown.");
        }
        this.processManager = null;
    }

    boolean isProcessAlive() {
        if (this.processManager == null) {
            return false;
        }
        return this.processManager.isAlive();
    }

    private static JavaProcessManager startRepeater(int repeaterPort, Level logLevel, boolean outputCaptureEnable) {
        Validate.notNull(logLevel);
        Validate.inclusiveBetween(1L, 65535L, repeaterPort, "The port must be in the inclusive range 1-65535.");
        Validate.validState(!CARepeaterServiceManager.isRepeaterRunning(repeaterPort), "The repeater is already running on port " + repeaterPort, new Object[0]);
        logger.fine("Starting the repeater in a separate process...");
        logger.fine("The following local interfaces have been discovered...");
        List<Inet4Address> addrList = NetworkUtilities.getLocalNetworkInterfaceAddresses();
        addrList.forEach(ip -> logger.fine(ip.toString()));
        Properties properties = new Properties();
        properties.put("java.net.preferIPv4Stack", "true");
        properties.put("java.net.preferIPv6Stack", "false");
        properties.put("CA_LIBRARY_LOG_LEVEL", logLevel.toString());
        String repeaterPortAsString = Integer.toString(repeaterPort);
        String[] programArgs = new String[]{"-p", repeaterPortAsString};
        JavaProcessManager processManager = new JavaProcessManager(CARepeater.class, properties, programArgs);
        processManager.start(outputCaptureEnable);
        return processManager;
    }

    private static void stopRepeater(JavaProcessManager repeaterProcessManager) {
        Validate.notNull(repeaterProcessManager);
        if (repeaterProcessManager.isAlive()) {
            logger.fine("Sending the CA Repeater a termination signal...");
            repeaterProcessManager.shutdown();
            logger.fine("The CA Repeater was sent a termination signal.");
        } else {
            logger.fine("The CA Repeater process was no longer alive => nothing to do.");
        }
    }
}

