/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.epics.ca.ThreadWatcher;
import org.epics.ca.impl.repeater.CARepeater;
import org.epics.ca.impl.repeater.CARepeaterServiceInstance;
import org.epics.ca.impl.repeater.CARepeaterServiceManager;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.util.logging.LibraryLogManager;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.provider.Arguments;

public class CARepeaterServiceInstanceTest {
    private static final Logger logger = LibraryLogManager.getLogger(CARepeaterServiceInstanceTest.class);
    private ThreadWatcher threadWatcher;
    private static final int testPort = 5065;
    private static final Level caRepeaterDebugLevel = Level.ALL;
    private static final boolean caRepeaterOutputCaptureEnable = false;

    @BeforeAll
    static void beforeAll() {
        MatcherAssert.assertThat(NetworkUtilities.verifyTargetPlatformNetworkStackIsChannelAccessCompatible(), Is.is(true));
        if (NetworkUtilities.isVpnActive()) {
            Assertions.fail("This test is not supported when a VPN connection is active on the local network interface.");
        }
    }

    @BeforeEach
    void beforeEach() {
        this.threadWatcher = ThreadWatcher.start();
        InetSocketAddress wildcardAddress = new InetSocketAddress(5065);
        logger.info("Checking Test Precondition: CA Repeater should NOT be running... on: " + wildcardAddress);
        if (CARepeaterServiceManager.isRepeaterRunning(5065)) {
            logger.info("Test Precondition FAILED: the CA Repeater was detected to be already running.");
            Assertions.fail();
        } else {
            logger.info("Test Precondition OK: the CA Repeater was not detected to be already running.");
        }
        logger.info("Starting Test.");
    }

    @AfterEach
    void afterEach() {
        this.threadWatcher.verify();
    }

    @Test
    void testStartRepeater() throws Throwable {
        logger.info("Starting CA Repeater in separate process.");
        CARepeaterServiceInstance instance = new CARepeaterServiceInstance(5065);
        instance.start();
        logger.info("The CA Repeater process was created.");
        logger.info("Verifying that the CA Repeater process is reported as being alive...");
        try {
            MatcherAssert.assertThat(instance.isProcessAlive(), Is.is(true));
            logger.info("OK");
            logger.info("Waiting a moment to allow the spawned process time to reserve the listening port...");
            Thread.sleep(1500L);
            logger.info("Waiting completed.");
            logger.info("Verifying that the CA Repeater is detected as running...");
            MatcherAssert.assertThat(CARepeaterServiceManager.isRepeaterRunning(5065), Is.is(true));
            logger.info("OK");
            logger.info("Shutting down the CA Repeater process...");
            instance.shutdown();
            logger.info("Verifying that the CA Repeater process is no longer reported as being alive...");
            MatcherAssert.assertThat(instance.isProcessAlive(), Is.is(false));
            logger.info("OK");
            logger.info("Waiting a moment to allow the OS to release the listening port...");
            Thread.sleep(1500L);
            logger.info("Verifying that the CA Repeater is no longer detected as running...");
            MatcherAssert.assertThat(CARepeaterServiceManager.isRepeaterRunning(5065), Is.is(false));
            logger.info("OK");
        }
        finally {
            instance.shutdown();
        }
    }

    @Test
    void testIsRepeaterRunning_startRepeaterInCurrentJvmProcess() throws Throwable {
        CARepeater repeater = new CARepeater(5065);
        repeater.start();
        Thread.sleep(1500L);
        MatcherAssert.assertThat(CARepeaterServiceManager.isRepeaterRunning(5065), Is.is(true));
        repeater.shutdown();
        Thread.sleep(1500L);
        MatcherAssert.assertThat(CARepeaterServiceManager.isRepeaterRunning(5065), Is.is(false));
    }

    private static Stream<Arguments> getArgumentsForTestIsRepeaterRunning_detectsSocketReservedInDifferentJvmOnDifferentLocalAddresses() {
        List<Inet4Address> localAddressList = NetworkUtilities.getLocalNetworkInterfaceAddresses();
        List localAddresses = localAddressList.stream().map(Inet4Address::getHostAddress).collect(Collectors.toList());
        return localAddresses.stream().map(xva$0 -> Arguments.of(xva$0));
    }
}

