/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.epics.ca.ThreadWatcher;
import org.epics.ca.impl.JavaProcessManager;
import org.epics.ca.impl.repeater.CARepeaterServiceManager;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.impl.repeater.UdpSocketReserver;
import org.epics.ca.impl.repeater.UdpSocketUtilities;
import org.epics.ca.util.logging.LibraryLogManager;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class CARepeaterServiceManagerTest {
    private static final Logger logger = LibraryLogManager.getLogger(CARepeaterServiceManagerTest.class);
    private ThreadWatcher threadWatcher;
    private static final int testPort = 5065;
    private static final Level caRepeaterDebugLevel = Level.ALL;
    private static final boolean caRepeaterOutputCaptureEnable = false;

    @BeforeAll
    static void beforeAll() {
        MatcherAssert.assertThat(NetworkUtilities.verifyTargetPlatformNetworkStackIsChannelAccessCompatible(), Is.is(true));
        if (NetworkUtilities.isVpnActive()) {
            Assertions.fail("This test is not supported when a VPN connection is active on the local network interface.");
        }
    }

    @BeforeEach
    void beforeEach() {
        this.threadWatcher = ThreadWatcher.start();
        InetSocketAddress wildcardAddress = new InetSocketAddress(5065);
        logger.info("Checking Test Precondition: CA Repeater should NOT be running... on: " + wildcardAddress);
        if (CARepeaterServiceManager.isRepeaterRunning(5065)) {
            logger.info("Test Precondition FAILED: the CA Repeater was detected to be already running.");
            Assertions.fail();
        } else {
            logger.info("Test Precondition OK: the CA Repeater was not detected to be already running.");
        }
        logger.info("Starting Test.");
    }

    @AfterEach
    void afterEach() {
        this.threadWatcher.verify();
    }

    @Test
    void testNothingShouldBeRunningOnRepeaterPort() {
    }

    @Test
    void testCARepeaterServiceManager_requestAndCancelService() {
        CARepeaterServiceManager.requestServiceOnPort(2);
        MatcherAssert.assertThat(CARepeaterServiceManager.getServiceInstances(), Is.is(1));
        CARepeaterServiceManager.cancelServiceRequestOnPort(2);
        MatcherAssert.assertThat(CARepeaterServiceManager.getServiceInstances(), Is.is(0));
    }

    @Test
    void testCARepeaterServiceManager_requestAndCancelServiceTwiceOnSamePort() {
        MatcherAssert.assertThat(CARepeaterServiceManager.getServiceInstances(), Is.is(0));
        CARepeaterServiceManager.requestServiceOnPort(2);
        MatcherAssert.assertThat(CARepeaterServiceManager.getServiceInstances(), Is.is(1));
        CARepeaterServiceManager.requestServiceOnPort(2);
        MatcherAssert.assertThat(CARepeaterServiceManager.getServiceInstances(), Is.is(1));
        CARepeaterServiceManager.cancelServiceRequestOnPort(2);
        MatcherAssert.assertThat(CARepeaterServiceManager.getServiceInstances(), Is.is(1));
        CARepeaterServiceManager.cancelServiceRequestOnPort(2);
        MatcherAssert.assertThat(CARepeaterServiceManager.getServiceInstances(), Is.is(0));
    }

    @Test
    void testCARepeaterServiceManager_requestAndCancelServiceOnDifferentPorts() {
        MatcherAssert.assertThat(CARepeaterServiceManager.getServiceInstances(), Is.is(0));
        CARepeaterServiceManager.requestServiceOnPort(22);
        MatcherAssert.assertThat(CARepeaterServiceManager.getServiceInstances(), Is.is(1));
        CARepeaterServiceManager.requestServiceOnPort(33);
        MatcherAssert.assertThat(CARepeaterServiceManager.getServiceInstances(), Is.is(2));
        CARepeaterServiceManager.cancelServiceRequestOnPort(999);
        MatcherAssert.assertThat(CARepeaterServiceManager.getServiceInstances(), Is.is(2));
        CARepeaterServiceManager.cancelServiceRequestOnPort(22);
        MatcherAssert.assertThat(CARepeaterServiceManager.getServiceInstances(), Is.is(1));
        CARepeaterServiceManager.cancelServiceRequestOnPort(33);
        MatcherAssert.assertThat(CARepeaterServiceManager.getServiceInstances(), Is.is(0));
    }

    @Test
    void testIsRepeaterRunning_detectsShareableSocketWhenReservedInSameJvm() throws Throwable {
        try (DatagramSocket ignored = UdpSocketUtilities.createBroadcastAwareListeningSocket(5065, true);){
            MatcherAssert.assertThat(CARepeaterServiceManager.isRepeaterRunning(5065), Is.is(true));
        }
        MatcherAssert.assertThat(CARepeaterServiceManager.isRepeaterRunning(5065), Is.is(false));
    }

    @Test
    void testIsRepeaterRunning_detectsNonShareableSocketWhenReservedInSameJvm() throws Throwable {
        try (DatagramSocket ignored = UdpSocketUtilities.createBroadcastAwareListeningSocket(5065, false);){
            MatcherAssert.assertThat(CARepeaterServiceManager.isRepeaterRunning(5065), Is.is(true));
        }
        MatcherAssert.assertThat(CARepeaterServiceManager.isRepeaterRunning(5065), Is.is(false));
    }

    @MethodSource(value={"getArgumentsForTestIsRepeaterRunning_detectsSocketReservedInDifferentJvmOnDifferentLocalAddresses"})
    @ParameterizedTest
    void testIsRepeaterRunning_detectsSocketReservedInDifferentJvmOnDifferentLocalAddress(String localAddress) throws Throwable {
        Validate.notNull(localAddress, "The localAddress was not provided.", new Object[0]);
        logger.info("Checking whether repeater instance detected on local address: '" + localAddress + "'");
        int portToReserve = 5065;
        int reservationTimeInMillis = 3000;
        JavaProcessManager processManager = UdpSocketReserver.start(localAddress, 5065, 3000);
        Thread.sleep(1500L);
        MatcherAssert.assertThat(processManager.isAlive(), Is.is(true));
        MatcherAssert.assertThat("The isRepeaterRunning method failed to detect that the socket was reserved.", CARepeaterServiceManager.isRepeaterRunning(5065), Is.is(true));
        processManager.waitFor(5000L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat(processManager.isAlive(), Is.is(false));
        MatcherAssert.assertThat("The isRepeaterRunning method failed to detect that the socket is now available.", CARepeaterServiceManager.isRepeaterRunning(5065), Is.is(false));
        logger.info("The test PASSED.");
    }

    private static Stream<Arguments> getArgumentsForTestIsRepeaterRunning_detectsSocketReservedInDifferentJvmOnDifferentLocalAddresses() {
        List<Inet4Address> localAddressList = NetworkUtilities.getLocalNetworkInterfaceAddresses();
        List localAddresses = localAddressList.stream().map(Inet4Address::getHostAddress).collect(Collectors.toList());
        return localAddresses.stream().map(xva$0 -> Arguments.of(xva$0));
    }
}

