/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.epics.ca.ThreadWatcher;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.util.logging.LibraryLogManager;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class NetworkUtilitiesTest {
    private static final Logger logger = LibraryLogManager.getLogger(NetworkUtilitiesTest.class);
    private ThreadWatcher threadWatcher;

    NetworkUtilitiesTest() {
    }

    @BeforeAll
    static void beforeAll() {
        MatcherAssert.assertThat(NetworkUtilities.verifyTargetPlatformNetworkStackIsChannelAccessCompatible(), Is.is(true));
    }

    @BeforeEach
    void beforeEach() {
        this.threadWatcher = ThreadWatcher.start();
    }

    @AfterEach
    void afterEach() {
        this.threadWatcher.verify();
    }

    @Test
    void testIsThisMyIp_suppliedWithNullThrowsNullPointerException() {
        Assertions.assertThrows(NullPointerException.class, () -> NetworkUtilities.isThisMyIpAddress(null));
    }

    @Test
    void testIsThisMyIp_withMiscellaneousAddresses() throws UnknownHostException {
        MatcherAssert.assertThat(NetworkUtilities.isThisMyIpAddress(InetAddress.getByName("bbc.co.uk")), Is.is(false));
        MatcherAssert.assertThat(NetworkUtilities.isThisMyIpAddress(InetAddress.getLoopbackAddress()), Is.is(true));
        MatcherAssert.assertThat(NetworkUtilities.isThisMyIpAddress(InetAddress.getLocalHost()), Is.is(true));
        MatcherAssert.assertThat(NetworkUtilities.isThisMyIpAddress(InetAddress.getByName("127.0.0.1")), Is.is(true));
        MatcherAssert.assertThat(NetworkUtilities.isThisMyIpAddress(InetAddress.getByName("127.0.0.8")), Is.is(true));
        MatcherAssert.assertThat(NetworkUtilities.isThisMyIpAddress(InetAddress.getByName("0.0.0.0")), Is.is(true));
        MatcherAssert.assertThat(NetworkUtilities.isThisMyIpAddress(InetAddress.getByName("192.168.0.1")), Is.is(false));
    }

    @Test
    void testIsThisMyIp_withAllLocalHostNameAddresses() throws UnknownHostException {
        String hostName = InetAddress.getLocalHost().getHostName();
        InetAddress[] localAddresses = InetAddress.getAllByName(hostName);
        Arrays.asList(localAddresses).forEach(addr -> {
            logger.info("Testing with IP: " + addr);
            MatcherAssert.assertThat(NetworkUtilities.isThisMyIpAddress(addr), Is.is(true));
        });
    }

    @Test
    void testIsThisMyIp_withAllLocalHostAddresses() throws UnknownHostException {
        InetAddress[] localAddresses = InetAddress.getAllByName("localhost");
        Arrays.asList(localAddresses).forEach(addr -> {
            logger.info("Testing with IP: " + addr);
            MatcherAssert.assertThat(NetworkUtilities.isThisMyIpAddress(addr), Is.is(true));
        });
    }

    @Test
    void testGetLocalNetworkInterfaceAddresses() {
        logger.info("The following network addresses have been detected on the local network interface:");
        List<Inet4Address> list = NetworkUtilities.getLocalNetworkInterfaceAddresses();
        list.forEach(addr -> logger.info("- " + addr.toString()));
    }

    @Test
    void testGetLocalBroadcastAddresses() {
        logger.info("The following broadcast addresses have been detected on the local network interface:");
        List<Inet4Address> list = NetworkUtilities.getLocalBroadcastAddresses();
        list.forEach(addr -> logger.info("- " + addr.toString()));
    }

    @Test
    void testIsVpnActive() {
        NetworkUtilities.isVpnActive();
    }
}

