/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.epics.ca.impl.JavaProcessManager;
import org.epics.ca.util.logging.LibraryLogManager;

class UdpSocketReserver {
    private static final Logger logger = LibraryLogManager.getLogger(UdpSocketReserver.class);

    UdpSocketReserver() {
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            logger.info("Usage: java -cp <classpath> org.epics.ca.impl.repeater.UdpSocketReserver <arg1> <arg2> <arg3>");
            logger.info("Where: arg1 = localAddress; arg2 = port; arg3 = reserveTimeInMillis");
            return;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(args[0]);
            int port = Integer.parseInt(args[1]);
            long sleepTimeInMillis = Integer.parseInt(args[2]);
            logger.info("Reserving socket: '" + inetAddress + ":" + port + "' for '" + sleepTimeInMillis + "' milliseconds.");
            try (DatagramSocket listeningSocket = new DatagramSocket(null);){
                listeningSocket.setReuseAddress(false);
                listeningSocket.bind(new InetSocketAddress(inetAddress, port));
                logger.info("Sleeping...");
                Thread.sleep(sleepTimeInMillis);
                logger.info("Awake again...");
                logger.info("Releasing socket.");
            }
        }
        catch (InterruptedException | SocketException | UnknownHostException ex) {
            logger.warning("The program failed to run as expected due to the following exception: '" + ex + "'.");
            System.exit(-1);
        }
        System.exit(0);
    }

    public static JavaProcessManager start(String address, int port, int socketReservationTime) {
        Validate.notBlank(address, "The reservation socket cannot be blank.", new Object[0]);
        Validate.inclusiveBetween(0L, 65535L, port, "The port must be in the range 0-65535.");
        Validate.isTrue(socketReservationTime >= 0, "The reservation time must be greater than or equal to zero.", new Object[0]);
        Properties properties = new Properties();
        properties.setProperty("java.net.preferIPv4Stack", "true");
        properties.setProperty("java.net.preferIPv6Stack", "false");
        String[] programArgs = new String[]{address, String.valueOf(port), String.valueOf(socketReservationTime)};
        JavaProcessManager processManager = new JavaProcessManager(UdpSocketReserver.class, properties, programArgs);
        processManager.start(true);
        return processManager;
    }
}

