/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.StopWatch;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.impl.repeater.UdpSocketUtilities;
import org.epics.ca.util.logging.LibraryLogManager;

public class UdpSocketTester {
    private static final Logger logger = LibraryLogManager.getLogger(UdpSocketTester.class);

    public static void main(String[] args) {
        int testPeriodInSeconds;
        int port;
        if (!NetworkUtilities.verifyTargetPlatformNetworkStackIsChannelAccessCompatible()) {
            return;
        }
        if (args.length != 2) {
            System.out.println("Usage: java -cp <caJarFile> org.epics.ca.impl.repeater.UdpSocketTester <port> <testPeriodInSeconds>");
            return;
        }
        try {
            port = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ex) {
            System.out.println("The supplied argument ('" + args[0] + "') could not be converted to an integer.");
            return;
        }
        if (port < 0 || port > 65535) {
            System.out.println("The supplied argument ('" + args[0] + "') was outside the allowed range (0-65535");
            return;
        }
        try {
            testPeriodInSeconds = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            System.out.println("The supplied argument ('" + args[1] + "') could not be converted to an integer.");
            return;
        }
        if (testPeriodInSeconds < 1) {
            System.out.println("The supplied argument ('" + args[1] + "') was not positive.");
            return;
        }
        if (UdpSocketTester.checkSocket(port, testPeriodInSeconds)) {
            System.out.println("The test PASSED. The socket was detected as being both available and reservable.");
            System.exit(0);
        } else {
            System.out.println("The test FAILED. The socket is NOT available/reservable.");
            System.exit(-1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkSocket(int testPort, int testPeriodInSeconds) {
        Validate.inclusiveBetween(0L, 65535L, testPort);
        Validate.isTrue(testPeriodInSeconds > 0);
        System.out.println("Checking socket based on port: '" + testPort + "'...");
        InetSocketAddress wildcardAddress = new InetSocketAddress(testPort);
        StopWatch stopWatch = StopWatch.createStarted();
        while (stopWatch.getTime(TimeUnit.SECONDS) < (long)testPeriodInSeconds) {
            logger.finest("Checking that the socket is detected as being available: " + wildcardAddress);
            if (!UdpSocketUtilities.isSocketAvailable(wildcardAddress)) {
                System.out.println("The socket was NOT detected as being available.");
                System.exit(-1);
            }
            logger.finest("Socket available.");
            try {
                DatagramSocket dummy = UdpSocketUtilities.createBroadcastAwareListeningSocket(testPort, false);
                Throwable throwable = null;
                try {
                    logger.finest("Socket reserved.");
                    if (!UdpSocketUtilities.isSocketAvailable(wildcardAddress)) continue;
                    logger.finest("Socket available = true");
                    System.out.println("The socket was NOT detected as being reserved.");
                    boolean bl = false;
                    return bl;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (dummy == null) continue;
                    if (throwable != null) {
                        try {
                            dummy.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    dummy.close();
                }
            }
            catch (SocketException ex) {
                System.out.println("The socket was NOT reservable.");
            }
        }
        return true;
    }
}

