/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.epics.ca.util.logging.LibraryLogManager;

class UdpSocketUtilities {
    private static final Logger logger = LibraryLogManager.getLogger(UdpSocketUtilities.class);

    UdpSocketUtilities() {
    }

    static DatagramSocket createUnboundSendSocket() throws SocketException {
        DatagramSocket socket = UdpSocketUtilities.createUnboundSocket();
        return socket;
    }

    static DatagramSocket createEphemeralSendSocket(boolean enableBroadcasts) throws SocketException {
        DatagramSocket socket = UdpSocketUtilities.createUnboundSocket();
        socket.setBroadcast(enableBroadcasts);
        boolean EPHEMERAL_PORT = false;
        InetSocketAddress inetSocketAddress = new InetSocketAddress(0);
        socket.bind(inetSocketAddress);
        return socket;
    }

    static DatagramSocket createBroadcastAwareListeningSocket(int port, boolean shareable) throws SocketException {
        Validate.inclusiveBetween(1L, 65535L, port);
        DatagramSocket socket = new DatagramSocket(null);
        InetSocketAddress wildcardBindAddress = new InetSocketAddress(port);
        socket.setReuseAddress(shareable);
        logger.finest("Binding to: " + wildcardBindAddress);
        socket.bind(wildcardBindAddress);
        Validate.isTrue(socket.getReuseAddress() == shareable, "The Socket REUSE mode was not as expected. Perhaps it is not supported on this platform.", new Object[0]);
        Validate.isTrue(socket.getBroadcast(), "The Socket BROADCAST mode was not as expected. Perhaps it is not supported on this platform.", new Object[0]);
        return socket;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    static boolean isSocketAvailable(InetSocketAddress targetSocketAddress) {
        logger.finest("Checking whether a UDP socket is available for target address '" + targetSocketAddress + "'.");
        try {
            Throwable throwable = null;
            try (DatagramSocket socket = new DatagramSocket(null);){
                logger.finest("Socket created ok.");
                socket.setReuseAddress(false);
                logger.finest("Socket SO_REUSE set to FALSE ok.");
                try {
                    socket.bind(targetSocketAddress);
                    logger.finest("Socket bind ok.");
                    boolean bl = true;
                    return bl;
                }
                catch (SocketException ex) {
                    boolean bl;
                    block19: {
                        block20: {
                            bl = false;
                            if (socket == null) break block19;
                            if (throwable == null) break block20;
                            try {
                                socket.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block19;
                        }
                        socket.close();
                    }
                    return bl;
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                }
            }
        }
        catch (RuntimeException | SocketException ex) {
            String msg = "An unexpected exception was thrown.";
            logger.log(Level.WARNING, "An unexpected exception was thrown.", ex);
            throw new RuntimeException("An unexpected exception was thrown.", ex);
        }
    }

    private static DatagramSocket createUnboundSocket() throws SocketException {
        return new DatagramSocket(null);
    }
}

