/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.search;

import java.util.Comparator;

public class SearchTimer
extends Thread {
    protected final Heap heap = new Heap(64);
    protected final RunLoop runLoop = new RunLoop();
    protected Thread thread;

    public synchronized void executeAfterDelay(long millisecondsToDelay, TimerTask task) {
        long runtime = System.currentTimeMillis() + millisecondsToDelay;
        task.setTimeToRun(millisecondsToDelay, runtime);
        this.heap.insert(task);
        this.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rescheduleAllAfterDelay(long millisecondsToDelay) {
        long timeToRun = System.currentTimeMillis() + millisecondsToDelay;
        Heap heap = this.heap;
        synchronized (heap) {
            Object[] nodes = this.heap.getNodes();
            int count = this.heap.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((TimerTask)nodes[i2]).setTimeToRun(millisecondsToDelay, timeToRun);
            }
        }
        this.restart();
    }

    public static void cancel(Object taskID) {
        ((TimerTask)taskID).setCancelled();
    }

    public synchronized Thread getThread() {
        return this.thread;
    }

    protected synchronized void clearThread() {
        this.thread = null;
    }

    public synchronized void restart() {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this.runLoop, this.getClass().getName());
            this.thread.setDaemon(true);
            this.thread.start();
        } else {
            this.notify();
        }
    }

    public synchronized void shutDown() {
        this.heap.clear();
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = null;
    }

    protected synchronized TimerTask nextTask(boolean blockAndExtract, long dt) {
        try {
            while (!Thread.interrupted()) {
                TimerTask task = (TimerTask)this.heap.peek();
                if (task == null) {
                    if (!blockAndExtract) {
                        return null;
                    }
                    this.wait();
                    continue;
                }
                long now = System.currentTimeMillis();
                long when = task.getTimeToRun();
                if (when - dt > now) {
                    if (!blockAndExtract) {
                        return null;
                    }
                    this.wait(when - now);
                    continue;
                }
                if (!blockAndExtract) {
                    return task;
                }
                task = (TimerTask)this.heap.extract();
                if (task.getCancelled()) continue;
                return task;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    public boolean hasNext(long dT) {
        return this.nextTask(false, dT) != null;
    }

    public static class Heap {
        protected Object[] nodes_;
        protected int count_ = 0;
        protected final Comparator cmp_;

        public Heap(int capacity, Comparator cmp) throws IllegalArgumentException {
            if (capacity <= 0) {
                throw new IllegalArgumentException();
            }
            this.nodes_ = new Object[capacity];
            this.cmp_ = cmp;
        }

        public Heap(int capacity) {
            this(capacity, null);
        }

        protected int compare(Object a, Object b) {
            if (this.cmp_ == null) {
                return ((Comparable)a).compareTo(b);
            }
            return this.cmp_.compare(a, b);
        }

        protected final int parent(int k) {
            return (k - 1) / 2;
        }

        protected final int left(int k) {
            return 2 * k + 1;
        }

        protected final int right(int k) {
            return 2 * (k + 1);
        }

        public synchronized void insert(Object x) {
            int par;
            if (this.count_ >= this.nodes_.length) {
                int newcap = 3 * this.nodes_.length / 2 + 1;
                Object[] newnodes = new Object[newcap];
                System.arraycopy(this.nodes_, 0, newnodes, 0, this.nodes_.length);
                this.nodes_ = newnodes;
            }
            int k = this.count_++;
            while (k > 0 && this.compare(x, this.nodes_[par = this.parent(k)]) < 0) {
                this.nodes_[k] = this.nodes_[par];
                k = par;
            }
            this.nodes_[k] = x;
        }

        public synchronized Object extract() {
            int l;
            if (this.count_ < 1) {
                return null;
            }
            int k = 0;
            Object least = this.nodes_[k];
            --this.count_;
            Object x = this.nodes_[this.count_];
            this.nodes_[this.count_] = null;
            while ((l = this.left(k)) < this.count_) {
                int child;
                int r = this.right(k);
                int n = child = r >= this.count_ || this.compare(this.nodes_[l], this.nodes_[r]) < 0 ? l : r;
                if (this.compare(x, this.nodes_[child]) <= 0) break;
                this.nodes_[k] = this.nodes_[child];
                k = child;
            }
            this.nodes_[k] = x;
            return least;
        }

        public synchronized Object peek() {
            if (this.count_ > 0) {
                return this.nodes_[0];
            }
            return null;
        }

        public synchronized int size() {
            return this.count_;
        }

        public synchronized void clear() {
            for (int i2 = 0; i2 < this.count_; ++i2) {
                this.nodes_[i2] = null;
            }
            this.count_ = 0;
        }

        public synchronized Object[] getNodes() {
            return this.nodes_;
        }
    }

    protected class RunLoop
    implements Runnable {
        protected RunLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                TimerTask task;
                while ((task = SearchTimer.this.nextTask(true, 0L)) != null) {
                    long millisecondsToDelay = task.timeout();
                    if (millisecondsToDelay <= 0L) continue;
                    long runtime = System.currentTimeMillis() + millisecondsToDelay;
                    task.setTimeToRun(millisecondsToDelay, runtime);
                    SearchTimer.this.heap.insert(task);
                }
            }
            finally {
                SearchTimer.this.clearThread();
            }
        }
    }

    public static abstract class TimerTask
    implements Comparable<TimerTask> {
        private long timeToRun;
        private long delay;
        private boolean cancelled = false;

        synchronized void setCancelled() {
            this.cancelled = true;
        }

        synchronized boolean getCancelled() {
            return this.cancelled;
        }

        synchronized void setTimeToRun(long d, long rt) {
            this.delay = d;
            this.timeToRun = rt;
        }

        public synchronized long getTimeToRun() {
            return this.timeToRun;
        }

        public synchronized long getDelay() {
            return this.delay;
        }

        @Override
        public int compareTo(TimerTask other) {
            long a = this.getTimeToRun();
            long b = other.getTimeToRun();
            return Long.compare(a, b);
        }

        public abstract long timeout();
    }
}

